/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.hacomment;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DfHacoMapPiece {
    protected final String diffCode;
    protected final String diffDate;
    protected final String hacomment;
    protected final String diffComment;
    protected final List<String> authorList;
    protected final String pieceCode;
    protected final String pieceOwner;
    protected final LocalDateTime pieceDatetime;
    protected final List<String> previousPieceList;

    public DfHacoMapPiece(String diffCode, String diffDate, String hacomment, String diffComment, List<String> authorList, String pieceCode, String pieceOwner, LocalDateTime pieceDatetime, List<String> previousPieceList) {
        this.diffCode = diffCode;
        this.diffDate = diffDate;
        this.hacomment = hacomment;
        this.diffComment = diffComment;
        this.authorList = new ArrayList<String>(authorList);
        if (!authorList.contains(pieceOwner)) {
            this.authorList.add(pieceOwner);
        }
        this.pieceCode = pieceCode;
        this.pieceOwner = pieceOwner;
        this.pieceDatetime = pieceDatetime;
        this.previousPieceList = previousPieceList;
    }

    public DfHacoMapPiece(Map<String, Object> map) {
        this.diffCode = (String)map.get("diffCode");
        this.diffDate = (String)map.get("diffDate");
        this.hacomment = (String)map.get("hacomment");
        this.diffComment = (String)map.get("diffComment");
        this.authorList = (List)map.get("authorList");
        this.pieceCode = (String)map.get("pieceCode");
        this.pieceOwner = (String)map.get("pieceOwner");
        this.pieceDatetime = (LocalDateTime)map.get("pieceDatetime");
        this.previousPieceList = (List)map.get("previousPieceList");
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("diffCode", this.diffCode);
        map.put("diffDate", this.diffDate);
        map.put("hacomment", this.hacomment);
        map.put("diffComment", this.diffComment);
        map.put("authorList", this.authorList);
        map.put("pieceCode", this.pieceCode);
        map.put("pieceOwner", this.pieceOwner);
        map.put("pieceDatetime", this.pieceDatetime);
        map.put("previousPieceList", this.previousPieceList);
        return map;
    }

    public String getDiffCode() {
        return this.diffCode;
    }

    public String getDiffDate() {
        return this.diffDate;
    }

    public String getHacomment() {
        return this.hacomment;
    }

    public String getDiffComment() {
        return this.diffComment;
    }

    public List<String> getAuthorList() {
        return this.authorList;
    }

    public String getPieceCode() {
        return this.pieceCode;
    }

    public String getPieceOwner() {
        return this.pieceOwner;
    }

    public LocalDateTime getPieceDatetime() {
        return this.pieceDatetime;
    }

    public List<String> getPreviousPieceList() {
        return this.previousPieceList;
    }
}

