/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment.parts;

import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.helper.HandyDate;
import org.dbflute.infra.doc.decomment.DfDecoMapMapping;

public class DfDecoMapMappingPart {
    protected final String newTableName;
    protected final String newColumnName;
    protected final List<String> authorList;
    protected final String mappingCode;
    protected final String mappingOwner;
    protected final LocalDateTime mappingDatetime;
    protected final List<String> previousMappingList;

    public DfDecoMapMappingPart(DfDecoMapMapping mapping) {
        this.newTableName = mapping.getNewTableName();
        this.newColumnName = mapping.getNewColumnName();
        this.authorList = mapping.getAuthorList();
        this.mappingCode = mapping.getMappingCode();
        this.mappingOwner = mapping.getMappingOwner();
        this.mappingDatetime = mapping.getMappingDatetime();
        this.previousMappingList = mapping.getPreviousMappingList();
    }

    public DfDecoMapMappingPart(Map<String, Object> mappingMap) {
        this.newTableName = (String)mappingMap.get("newTableName");
        this.newColumnName = (String)mappingMap.get("newColumnName");
        this.authorList = ((List)mappingMap.get("authorList")).stream().map(obj -> (String)obj).collect(Collectors.toList());
        this.mappingCode = (String)mappingMap.get("mappingCode");
        this.mappingOwner = (String)mappingMap.get("mappingOwner");
        this.mappingDatetime = new HandyDate((String)mappingMap.get("mappingDatetime")).getLocalDateTime();
        this.previousMappingList = ((List)mappingMap.get("previousMappingList")).stream().map(obj -> (String)obj).collect(Collectors.toList());
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("newTableName", this.newTableName);
        map.put("newColumnName", this.newColumnName);
        map.put("authorList", this.authorList);
        map.put("mappingCode", this.mappingCode);
        map.put("mappingOwner", this.mappingOwner);
        map.put("mappingDatetime", this.mappingDatetime);
        map.put("previousMappingList", this.previousMappingList);
        return map;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public List<String> getAuthorList() {
        return this.authorList;
    }

    public String getMappingCode() {
        return this.mappingCode;
    }

    public String getMappingOwner() {
        return this.mappingOwner;
    }

    public LocalDateTime getMappingDatetime() {
        return this.mappingDatetime;
    }

    public List<String> getPreviousMappingList() {
        return this.previousMappingList;
    }
}

