/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment.parts;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapMappingPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapPropertyPart;

public class DfDecoMapColumnPart {
    protected final String columnName;
    protected final List<DfDecoMapMappingPart> mappingList;
    protected final List<DfDecoMapPropertyPart> propertyList;

    public DfDecoMapColumnPart(String columnName, List<DfDecoMapMappingPart> mappingList, List<DfDecoMapPropertyPart> propertyList) {
        this.columnName = columnName;
        this.mappingList = mappingList;
        this.propertyList = propertyList;
    }

    public DfDecoMapColumnPart(Map<String, Object> columnPartMap) {
        this.columnName = (String)columnPartMap.get("columnName");
        List mappingMapList = columnPartMap.getOrDefault("mappingList", Collections.emptyList());
        this.mappingList = mappingMapList.stream().map(DfDecoMapMappingPart::new).collect(Collectors.toList());
        List propertyMapList = (List)columnPartMap.get("propertyList");
        this.propertyList = propertyMapList.stream().map(DfDecoMapPropertyPart::new).collect(Collectors.toList());
    }

    public Map<String, Object> convertToMap() {
        List mappingMapList = this.mappingList.stream().map(DfDecoMapMappingPart::convertToMap).collect(Collectors.toList());
        List propertyMapList = this.propertyList.stream().map(DfDecoMapPropertyPart::convertToMap).collect(Collectors.toList());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("columnName", this.columnName);
        map.put("mappingList", mappingMapList);
        map.put("propertyList", propertyMapList);
        return map;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<DfDecoMapMappingPart> getMappingList() {
        return this.mappingList;
    }

    public List<DfDecoMapPropertyPart> getPropertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }
}

