/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.hook;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.dbflute.bhv.core.BehaviorCommandHook;
import org.dbflute.bhv.core.BehaviorCommandMeta;
import org.dbflute.hook.SqlFireHook;
import org.dbflute.hook.SqlFireReadyInfo;
import org.dbflute.hook.SqlFireResultInfo;
import org.dbflute.hook.SqlLogHandler;
import org.dbflute.hook.SqlLogInfo;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.hook.SqlResultInfo;
import org.dbflute.hook.SqlStringFilter;
import org.dbflute.util.DfTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackContext {
    private static final Logger _log = LoggerFactory.getLogger(CallbackContext.class);
    protected static final ThreadLocal<CallbackContext> _defaultThreadLocal = new ThreadLocal();
    protected static final CallbackContextHolder _defaultHolder;
    protected static CallbackContextHolder _holder;
    protected static boolean _locked;
    protected BehaviorCommandHook _behaviorCommandHook;
    protected SqlFireHook _sqlFireHook;
    protected SqlLogHandler _sqlLogHandler;
    protected SqlResultHandler _sqlResultHandler;
    protected SqlStringFilter _sqlStringFilter;

    public static CallbackContext getCallbackContextOnThread() {
        return CallbackContext.getActiveHolder().provide();
    }

    public static void setCallbackContextOnThread(CallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument 'callbackContext' must not be null.";
            throw new IllegalArgumentException(msg);
        }
        CallbackContext.getActiveHolder().save(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return CallbackContext.getActiveHolder().provide() != null;
    }

    public static void clearCallbackContextOnThread() {
        CallbackContext.getActiveHolder().save(null);
    }

    protected static CallbackContextHolder getActiveHolder() {
        return _holder;
    }

    public static void useSurrogateHolder(CallbackContextHolder holder) {
        CallbackContext.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting surrogate holder for callback context: " + holder);
        }
        _holder = holder != null ? holder : _defaultHolder;
        _locked = true;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the static world of the callback context!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the static world of the callback context!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!CallbackContext.isLocked()) {
            return;
        }
        String msg = "The callback context is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public static void setBehaviorCommandHookOnThread(BehaviorCommandHook behaviorCommandHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setBehaviorCommandHook(behaviorCommandHook);
    }

    public static boolean isExistBehaviorCommandHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook() != null;
    }

    public static void terminateLastBehaviorCommandHookOnThread() {
        CallbackContext.endCallback(context -> context.terminateLastBehaviorCommandHook());
    }

    public static void clearBehaviorCommandHookOnThread() {
        CallbackContext.endCallback(context -> context.setBehaviorCommandHook(null));
    }

    public static void setSqlFireHookOnThread(SqlFireHook sqlFireHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlFireHook(sqlFireHook);
    }

    public static boolean isExistSqlFireHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlFireHook() != null;
    }

    public static void terminateLastSqlFireHookOnThread() {
        CallbackContext.endCallback(context -> context.terminateLastSqlFireHook());
    }

    public static void clearSqlFireHookOnThread() {
        CallbackContext.endCallback(context -> context.setSqlFireHook(null));
    }

    public static void setSqlLogHandlerOnThread(SqlLogHandler sqlLogHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlLogHandler(sqlLogHandler);
    }

    public static boolean isExistSqlLogHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlLogHandler() != null;
    }

    public static void terminateLastSqlLogHandlerOnThread() {
        CallbackContext.endCallback(context -> context.terminateLastSqlLogHandler());
    }

    public static void clearSqlLogHandlerOnThread() {
        CallbackContext.endCallback(context -> context.setSqlLogHandler(null));
    }

    public static void setSqlResultHandlerOnThread(SqlResultHandler sqlResultHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlResultHandler(sqlResultHandler);
    }

    public static boolean isExistSqlResultHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlResultHandler() != null;
    }

    public static void terminateLastSqlResultHandlerOnThread() {
        CallbackContext.endCallback(context -> context.terminateLastSqlResultHandler());
    }

    public static void clearSqlResultHandlerOnThread() {
        CallbackContext.endCallback(context -> context.setSqlResultHandler(null));
    }

    public static void setSqlStringFilterOnThread(SqlStringFilter sqlStringFilter) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlStringFilter(sqlStringFilter);
    }

    public static boolean isExistSqlStringFilterOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlStringFilter() != null;
    }

    public static void terminateLastSqlStringFilterOnThread() {
        CallbackContext.endCallback(context -> context.terminateLastSqlStringFilter());
    }

    public static void clearSqlStringFilterOnThread() {
        CallbackContext.endCallback(context -> context.setSqlStringFilter(null));
    }

    protected static CallbackContext getOrCreateContext() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            return CallbackContext.getCallbackContextOnThread();
        }
        CallbackContext context = new CallbackContext();
        CallbackContext.setCallbackContextOnThread(context);
        return context;
    }

    protected static void endCallback(Consumer<CallbackContext> oneArgLambda) {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            oneArgLambda.accept(context);
            CallbackContext.clearContextIfNoInterface(context);
        }
    }

    protected static void clearContextIfNoInterface(CallbackContext context) {
        if (!context.hasAnyInterface()) {
            CallbackContext.clearCallbackContextOnThread();
        }
    }

    public boolean hasAnyInterface() {
        return this._behaviorCommandHook != null || this._sqlFireHook != null || this._sqlLogHandler != null || this._sqlResultHandler != null || this._sqlStringFilter != null;
    }

    public void setBehaviorCommandHook(BehaviorCommandHook behaviorCommandHook) {
        this._behaviorCommandHook = this._behaviorCommandHook != null && behaviorCommandHook != null && behaviorCommandHook.inheritsExistingHook() ? this.newInheritableBehaviorCommandHook(this._behaviorCommandHook, behaviorCommandHook) : behaviorCommandHook;
    }

    public void terminateLastBehaviorCommandHook() {
        this._behaviorCommandHook = this._behaviorCommandHook instanceof InheritableBehaviorCommandHook ? ((InheritableBehaviorCommandHook)this._behaviorCommandHook).getOriginally() : null;
    }

    public void setSqlFireHook(SqlFireHook sqlFireHook) {
        this._sqlFireHook = this._sqlFireHook != null && sqlFireHook != null && sqlFireHook.inheritsExistingHook() ? this.newInheritableSqlFireHook(this._sqlFireHook, sqlFireHook) : sqlFireHook;
    }

    public void terminateLastSqlFireHook() {
        this._sqlFireHook = this._sqlFireHook instanceof InheritableSqlFireHook ? ((InheritableSqlFireHook)this._sqlFireHook).getOriginally() : null;
    }

    public void setSqlLogHandler(SqlLogHandler sqlLogHandler) {
        this._sqlLogHandler = this._sqlLogHandler != null && sqlLogHandler != null && sqlLogHandler.inheritsExistingHandler() ? this.newInheritableSqlLogHandler(this._sqlLogHandler, sqlLogHandler) : sqlLogHandler;
    }

    public void terminateLastSqlLogHandler() {
        this._sqlLogHandler = this._sqlLogHandler instanceof InheritableSqlLogHandler ? ((InheritableSqlLogHandler)this._sqlLogHandler).getOriginally() : null;
    }

    public void setSqlResultHandler(SqlResultHandler sqlResultHandler) {
        this._sqlResultHandler = this._sqlResultHandler != null && sqlResultHandler != null && sqlResultHandler.inheritsExistingHandler() ? this.newInheritableSqlResultHandler(this._sqlResultHandler, sqlResultHandler) : sqlResultHandler;
    }

    public void terminateLastSqlResultHandler() {
        this._sqlResultHandler = this._sqlResultHandler instanceof InheritableSqlResultHandler ? ((InheritableSqlResultHandler)this._sqlResultHandler).getOriginally() : null;
    }

    public void setSqlStringFilter(SqlStringFilter sqlStringFilter) {
        this._sqlStringFilter = this._sqlStringFilter != null && sqlStringFilter != null && sqlStringFilter.inheritsExistingFilter() ? this.newInheritableSqlStringFilter(this._sqlStringFilter, sqlStringFilter) : sqlStringFilter;
    }

    public void terminateLastSqlStringFilter() {
        this._sqlStringFilter = this._sqlStringFilter instanceof InheritableSqlStringFilter ? ((InheritableSqlStringFilter)this._sqlStringFilter).getOriginally() : null;
    }

    protected InheritableBehaviorCommandHook newInheritableBehaviorCommandHook(BehaviorCommandHook originally, BehaviorCommandHook yourHook) {
        return new InheritableBehaviorCommandHook(originally, yourHook);
    }

    protected InheritableSqlFireHook newInheritableSqlFireHook(SqlFireHook originally, SqlFireHook yourHook) {
        return new InheritableSqlFireHook(originally, yourHook);
    }

    protected InheritableSqlLogHandler newInheritableSqlLogHandler(SqlLogHandler originally, SqlLogHandler yourHandler) {
        return new InheritableSqlLogHandler(originally, yourHandler);
    }

    protected InheritableSqlResultHandler newInheritableSqlResultHandler(SqlResultHandler originally, SqlResultHandler yourHandler) {
        return new InheritableSqlResultHandler(originally, yourHandler);
    }

    protected InheritableSqlStringFilter newInheritableSqlStringFilter(SqlStringFilter originally, SqlStringFilter yourFilter) {
        return new InheritableSqlStringFilter(originally, yourFilter);
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":{behaviorCommandHook=").append(this._behaviorCommandHook);
        sb.append(", sqlFireHook=").append(this._sqlFireHook);
        sb.append(", sqlLogHandler=").append(this._sqlLogHandler);
        sb.append(", sqlResultHandler=").append(this._sqlResultHandler);
        sb.append(", sqlStringFilter=").append(this._sqlStringFilter);
        sb.append("}");
        return sb.toString();
    }

    public BehaviorCommandHook getBehaviorCommandHook() {
        return this._behaviorCommandHook;
    }

    public SqlFireHook getSqlFireHook() {
        return this._sqlFireHook;
    }

    public SqlLogHandler getSqlLogHandler() {
        return this._sqlLogHandler;
    }

    public SqlResultHandler getSqlResultHandler() {
        return this._sqlResultHandler;
    }

    public SqlStringFilter getSqlStringFilter() {
        return this._sqlStringFilter;
    }

    static {
        _holder = _defaultHolder = new CallbackContextHolder(){

            @Override
            public CallbackContext provide() {
                return _defaultThreadLocal.get();
            }

            @Override
            public void save(CallbackContext context) {
                _defaultThreadLocal.set(context);
            }
        };
        _locked = true;
    }

    protected static interface InheritableCallback<CALL> {
        default public int countManagedHook() {
            CALL originally = this.getOriginally();
            int nestHookCount = originally instanceof InheritableBehaviorCommandHook ? ((InheritableBehaviorCommandHook)originally).countManagedHook() : 1;
            return nestHookCount + 1;
        }

        public CALL getOriginally();
    }

    protected static class InheritableSqlStringFilter
    implements SqlStringFilter,
    InheritableCallback<SqlStringFilter> {
        protected final SqlStringFilter _originally;
        protected final SqlStringFilter _yourFilter;

        public InheritableSqlStringFilter(SqlStringFilter originally, SqlStringFilter yourFilter) {
            this._originally = originally;
            this._yourFilter = yourFilter;
        }

        @Override
        public String filterSelectCB(BehaviorCommandMeta meta, String executedSql) {
            return this.doFilter(executedSql, (filter, sql) -> filter.filterSelectCB(meta, (String)sql));
        }

        @Override
        public String filterEntityUpdate(BehaviorCommandMeta meta, String executedSql) {
            return this.doFilter(executedSql, (filter, sql) -> filter.filterEntityUpdate(meta, (String)sql));
        }

        @Override
        public String filterQueryUpdate(BehaviorCommandMeta meta, String executedSql) {
            return this.doFilter(executedSql, (filter, sql) -> filter.filterQueryUpdate(meta, (String)sql));
        }

        @Override
        public String filterOutsideSql(BehaviorCommandMeta meta, String executedSql) {
            return this.doFilter(executedSql, (filter, sql) -> filter.filterOutsideSql(meta, (String)sql));
        }

        @Override
        public String filterProcedure(BehaviorCommandMeta meta, String executedSql) {
            return this.doFilter(executedSql, (filter, sql) -> filter.filterProcedure(meta, (String)sql));
        }

        protected String doFilter(String executedSql, BiFunction<SqlStringFilter, String, String> call) {
            String originallyFiltered = this.actuallyFilter(this._originally, executedSql, call);
            return this.actuallyFilter(this._yourFilter, originallyFiltered, call);
        }

        protected String actuallyFilter(SqlStringFilter filter, String executedSql, BiFunction<SqlStringFilter, String, String> call) {
            String filtered = call.apply(filter, executedSql);
            return filtered != null ? filtered : executedSql;
        }

        @Override
        public SqlStringFilter getOriginally() {
            return this._originally;
        }

        public SqlStringFilter getYourFilter() {
            return this._yourFilter;
        }
    }

    protected static class InheritableSqlResultHandler
    implements SqlResultHandler,
    InheritableCallback<SqlResultHandler> {
        protected final SqlResultHandler _originally;
        protected final SqlResultHandler _yourHandler;

        public InheritableSqlResultHandler(SqlResultHandler originally, SqlResultHandler yourHandler) {
            this._originally = originally;
            this._yourHandler = yourHandler;
        }

        @Override
        public void handle(SqlResultInfo info) {
            this._originally.handle(info);
            this._yourHandler.handle(info);
        }

        @Override
        public SqlResultHandler getOriginally() {
            return this._originally;
        }

        public SqlResultHandler getYourHandler() {
            return this._yourHandler;
        }
    }

    protected static class InheritableSqlLogHandler
    implements SqlLogHandler,
    InheritableCallback<SqlLogHandler> {
        protected final SqlLogHandler _originally;
        protected final SqlLogHandler _yourHandler;

        public InheritableSqlLogHandler(SqlLogHandler originally, SqlLogHandler yourHandler) {
            this._originally = originally;
            this._yourHandler = yourHandler;
        }

        @Override
        public void handle(SqlLogInfo info) {
            this._originally.handle(info);
            this._yourHandler.handle(info);
        }

        @Override
        public SqlLogHandler getOriginally() {
            return this._originally;
        }

        public SqlLogHandler getYourHandler() {
            return this._yourHandler;
        }
    }

    protected static class InheritableSqlFireHook
    implements SqlFireHook,
    InheritableCallback<SqlFireHook> {
        protected final SqlFireHook _originally;
        protected final SqlFireHook _yourHook;

        public InheritableSqlFireHook(SqlFireHook originally, SqlFireHook yourHook) {
            this._originally = originally;
            this._yourHook = yourHook;
        }

        @Override
        public void hookBefore(BehaviorCommandMeta meta, SqlFireReadyInfo fireReadyInfo) {
            this._originally.hookBefore(meta, fireReadyInfo);
            this._yourHook.hookBefore(meta, fireReadyInfo);
        }

        @Override
        public void hookFinally(BehaviorCommandMeta meta, SqlFireResultInfo fireResultInfo) {
            this._yourHook.hookFinally(meta, fireResultInfo);
            this._originally.hookFinally(meta, fireResultInfo);
        }

        @Override
        public SqlFireHook getOriginally() {
            return this._originally;
        }

        public SqlFireHook getYourHook() {
            return this._yourHook;
        }
    }

    protected static class InheritableBehaviorCommandHook
    implements BehaviorCommandHook,
    InheritableCallback<BehaviorCommandHook> {
        protected final BehaviorCommandHook _originally;
        protected final BehaviorCommandHook _yourHook;

        public InheritableBehaviorCommandHook(BehaviorCommandHook originally, BehaviorCommandHook yourHook) {
            this._originally = originally;
            this._yourHook = yourHook;
        }

        @Override
        public void hookBefore(BehaviorCommandMeta meta) {
            this._originally.hookBefore(meta);
            this._yourHook.hookBefore(meta);
        }

        @Override
        public void hookFinally(BehaviorCommandMeta meta, RuntimeException cause) {
            this._yourHook.hookFinally(meta, cause);
            this._originally.hookFinally(meta, cause);
        }

        @Override
        public BehaviorCommandHook getOriginally() {
            return this._originally;
        }

        public BehaviorCommandHook getYourHook() {
            return this._yourHook;
        }
    }

    public static interface CallbackContextHolder {
        public CallbackContext provide();

        public void save(CallbackContext var1);
    }
}

