/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.thread;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.helper.thread.CountDownRaceExecution;
import org.dbflute.helper.thread.CountDownRaceLatch;
import org.dbflute.helper.thread.CountDownRaceRunner;
import org.dbflute.helper.thread.exception.CountDownRaceExecutionException;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownRace {
    private static final Logger _log = LoggerFactory.getLogger(CountDownRace.class);
    protected final Map<Integer, Object> _runnerRequestMap;
    protected final ExecutorService _service;

    public CountDownRace(int runnerCount) {
        if (runnerCount < 1) {
            String msg = "The argument 'runnerCount' should not be minus or zero: " + runnerCount;
            throw new IllegalArgumentException(msg);
        }
        this._runnerRequestMap = this.newRunnerRequestMap(runnerCount);
        for (int i = 0; i < runnerCount; ++i) {
            int entryNumber = i + 1;
            this._runnerRequestMap.put(entryNumber, null);
        }
        this._service = this.prepareExecutorService();
    }

    public CountDownRace(List<Object> parameterList) {
        if (parameterList == null) {
            String msg = "The argument 'parameterList' should not be null or empty: " + parameterList;
            throw new IllegalArgumentException(msg);
        }
        this._runnerRequestMap = this.newRunnerRequestMap(parameterList.size());
        int index = 0;
        for (Object parameter : parameterList) {
            int entryNumber = index + 1;
            this._runnerRequestMap.put(entryNumber, parameter);
            ++index;
        }
        this._service = this.prepareExecutorService();
    }

    protected Map<Integer, Object> newRunnerRequestMap(int size) {
        return new LinkedHashMap<Integer, Object>(size);
    }

    protected ExecutorService prepareExecutorService() {
        return Executors.newCachedThreadPool();
    }

    public void readyGo(CountDownRaceExecution runnerLambda) {
        if (runnerLambda == null) {
            throw new IllegalArgumentException("The argument 'runnerLambda' should be not null.");
        }
        this.doReadyGo(runnerLambda);
    }

    protected void doReadyGo(CountDownRaceExecution execution) {
        if (this._runnerRequestMap.isEmpty()) {
            return;
        }
        int runnerCount = this._runnerRequestMap.size();
        CountDownLatch ready = new CountDownLatch(runnerCount);
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch goal = new CountDownLatch(runnerCount);
        CountDownRaceLatch ourLatch = new CountDownRaceLatch(runnerCount);
        Object lockObj = new Object();
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        for (Map.Entry<Integer, Object> entry : this._runnerRequestMap.entrySet()) {
            Integer entryNumber = entry.getKey();
            Object parameter = entry.getValue();
            Callable<Void> callable = this.createCallable(execution, ready, start, goal, ourLatch, entryNumber, parameter, lockObj);
            Future<Void> future = this._service.submit(callable);
            futureList.add(future);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("...Ready Go! CountDownRace just begun! (runner=" + runnerCount + ")");
        }
        start.countDown();
        try {
            goal.await();
            if (_log.isDebugEnabled()) {
                _log.debug("All runners finished line! (runner=" + runnerCount + ")");
            }
        }
        catch (InterruptedException e) {
            String msg = "goal.await() was interrupted!";
            throw new IllegalStateException(msg, e);
        }
        this.handleFuture(futureList, execution);
    }

    protected void handleFuture(List<Future<Void>> futureList, CountDownRaceExecution execution) {
        boolean throwImmediatelyByFirstCause = execution.isThrowImmediatelyByFirstCause();
        ArrayList<Throwable> runnerCauseList = new ArrayList<Throwable>();
        for (Future<Void> future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("future.get() was interrupted: " + future, e);
            }
            catch (ExecutionException e) {
                if (throwImmediatelyByFirstCause) {
                    throw new CountDownRaceExecutionException(this.buildRunnerGoalFailureNotice(), e.getCause());
                }
                runnerCauseList.add(e.getCause());
            }
        }
        if (!runnerCauseList.isEmpty()) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice(this.buildRunnerGoalFailureNotice());
            br.addItem("Advice");
            br.addElement("Confirm all causes thrown by runners.");
            br.addItem("Runner Cause");
            int index = 0;
            for (Throwable cause : runnerCauseList) {
                if (index > 0) {
                    br.addElement("");
                }
                this.buildRunnerExStackTrace(br, cause, 0);
                ++index;
            }
            String msg = br.buildExceptionMessage();
            throw new CountDownRaceExecutionException(msg, runnerCauseList);
        }
    }

    protected String buildRunnerGoalFailureNotice() {
        return "Failed to reach the goal of countdown race for runners.";
    }

    protected void buildRunnerExStackTrace(ExceptionMessageBuilder br, Throwable cause, int nestLevel) {
        Throwable nested;
        StringBuilder headerSb = new StringBuilder();
        if (nestLevel > 0) {
            headerSb.append("Caused by: ");
        }
        String causeNameBase = cause.getClass().getName() + ":";
        String causeMessage = cause.getMessage();
        if (causeMessage != null && Srl.contains(causeMessage, "\n")) {
            headerSb.append(causeNameBase);
            br.addElement(headerSb.toString());
            br.addElement(causeMessage);
        } else {
            headerSb.append(causeNameBase + " " + causeMessage);
            br.addElement(headerSb.toString());
        }
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (stackTrace == null) {
            return;
        }
        int limit = nestLevel == 0 ? 10 : 3;
        int index = 0;
        for (StackTraceElement element : stackTrace) {
            if (index > limit) {
                br.addElement("  ...");
                break;
            }
            String className = element.getClassName();
            String fileName = element.getFileName();
            int lineNumber = element.getLineNumber();
            String methodName = element.getMethodName();
            StringBuilder lineSb = new StringBuilder();
            lineSb.append("  at ").append(className).append(".").append(methodName).append("(").append(fileName);
            if (lineNumber >= 0) {
                lineSb.append(":").append(lineNumber);
            }
            lineSb.append(")");
            br.addElement(lineSb.toString());
            ++index;
        }
        if ((nested = cause.getCause()) != null && nested != cause) {
            this.buildRunnerExStackTrace(br, nested, nestLevel + 1);
        }
    }

    protected Callable<Void> createCallable(final CountDownRaceExecution execution, final CountDownLatch ready, final CountDownLatch start, final CountDownLatch goal, final CountDownRaceLatch ourLatch, final int entryNumber, final Object parameter, final Object lockObj) {
        execution.readyCaller();
        return new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                execution.hookBeforeCountdown();
                long threadId = Thread.currentThread().getId();
                try {
                    ready.countDown();
                    try {
                        start.await();
                    }
                    catch (InterruptedException e) {
                        String msg = "start.await() was interrupted: start=" + start;
                        throw new IllegalStateException(msg, e);
                    }
                    RuntimeException cause = null;
                    try {
                        execution.execute(CountDownRace.this.createRunner(threadId, ourLatch, entryNumber, parameter, lockObj));
                    }
                    catch (RuntimeException e) {
                        cause = e;
                    }
                    if (cause != null) {
                        throw cause;
                    }
                }
                finally {
                    execution.hookBeforeGoalFinally();
                    goal.countDown();
                    ourLatch.reset();
                }
                return null;
            }
        };
    }

    protected CountDownRaceRunner createRunner(long threadId, CountDownRaceLatch ourLatch, int entryNumber, Object parameter, Object lockObj) {
        return new CountDownRaceRunner(threadId, ourLatch, entryNumber, parameter, lockObj, this._runnerRequestMap.size());
    }
}

