/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.function.Consumer;

public class ProcessConsoleReader
extends Thread {
    protected final BufferedReader _reader;
    protected final Consumer<String> _liner;
    protected final StringBuilder _consoleSb = new StringBuilder();

    public ProcessConsoleReader(InputStream ins, String encoding, Consumer<String> liner) {
        this.assertObjectNotNull("ins", ins);
        this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
        try {
            this._reader = new BufferedReader(new InputStreamReader(ins, encoding));
            this._liner = liner;
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Failed to create a reader by the encoding: " + encoding;
            throw new IllegalStateException(msg);
        }
    }

    public String read() {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            String msg = "The join() was interrupted.";
            throw new IllegalStateException(msg, e);
        }
        return this._consoleSb.toString();
    }

    @Override
    public void run() {
        StringBuilder sb = this._consoleSb;
        try {
            String line;
            while ((line = this._reader.readLine()) != null) {
                this.handleLine(sb, line);
            }
        }
        catch (IOException e) {
            String msg = "Failed to read the stream: " + this._reader;
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void handleLine(StringBuilder sb, String line) {
        if (this._liner != null) {
            this._liner.accept(line);
        }
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(line);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }
}

