/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.jprop;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.dbflute.helper.jprop.JavaPropertiesProperty;
import org.dbflute.helper.jprop.JavaPropertiesReader;
import org.dbflute.helper.jprop.JavaPropertiesResult;
import org.dbflute.helper.jprop.JavaPropertiesStreamProvider;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;

public class ObjectiveProperties {
    protected final String _resourcePath;
    protected List<String> _extendsResourcePathList = DfCollectionUtil.newArrayListSized(4);
    protected boolean _checkImplicitOverride;
    protected String _streamEncoding;
    protected JavaPropertiesResult _javaPropertiesResult;

    public ObjectiveProperties(String resourcePath) {
        this._resourcePath = resourcePath;
    }

    public ObjectiveProperties extendsProperties(String ... extendsResourcePaths) {
        if (extendsResourcePaths != null && extendsResourcePaths.length > 0) {
            for (String extendsResourcePath : extendsResourcePaths) {
                this._extendsResourcePathList.add(extendsResourcePath);
            }
        }
        return this;
    }

    public ObjectiveProperties checkImplicitOverride() {
        this._checkImplicitOverride = true;
        return this;
    }

    public ObjectiveProperties encodeAsUTF8() {
        this._streamEncoding = "UTF-8";
        return this;
    }

    public ObjectiveProperties load() {
        String title = this.toTitle(this._resourcePath);
        JavaPropertiesReader reader = this.createJavaPropertiesReader(title);
        this.prepareExtendsProperties(reader);
        if (this._checkImplicitOverride) {
            reader.checkImplicitOverride();
        }
        if (this._streamEncoding != null) {
            reader.encodeAs(this._streamEncoding);
        }
        this._javaPropertiesResult = reader.read();
        return this;
    }

    protected JavaPropertiesReader createJavaPropertiesReader(String title) {
        return new JavaPropertiesReader(title, this.createJavaPropertiesStreamProvider());
    }

    protected JavaPropertiesStreamProvider createJavaPropertiesStreamProvider() {
        return new JavaPropertiesStreamProvider(){

            @Override
            public InputStream provideStream() throws IOException {
                return ObjectiveProperties.this.toStream(ObjectiveProperties.this._resourcePath);
            }
        };
    }

    protected void prepareExtendsProperties(JavaPropertiesReader reader) {
        for (final String extendsResourcePath : this._extendsResourcePathList) {
            String title = this.toTitle(extendsResourcePath);
            reader.extendsProperties(title, new JavaPropertiesStreamProvider(){

                @Override
                public InputStream provideStream() throws IOException {
                    return ObjectiveProperties.this.toStream(extendsResourcePath);
                }
            });
        }
    }

    protected String toTitle(String path) {
        return DfTypeUtil.toClassTitle(this) + ":" + path;
    }

    protected InputStream toStream(String resourcePath) {
        return this.getClass().getClassLoader().getResourceAsStream(resourcePath);
    }

    public String get(String propertyKey) {
        JavaPropertiesProperty property = this._javaPropertiesResult.getProperty(propertyKey);
        return property != null ? property.getPropertyValue() : null;
    }

    public Integer getAsInteger(String propertyKey) {
        String value = this.get(propertyKey);
        return value != null ? DfTypeUtil.toInteger(value) : null;
    }

    public Long getAsLong(String propertyKey) {
        String value = this.get(propertyKey);
        return value != null ? DfTypeUtil.toLong(value) : null;
    }

    public BigDecimal getAsDecimal(String propertyKey) {
        String value = this.get(propertyKey);
        return value != null ? DfTypeUtil.toBigDecimal(value) : null;
    }

    public Date getAsDate(String propertyKey) {
        String value = this.get(propertyKey);
        return value != null ? DfTypeUtil.toDate(value) : null;
    }

    public boolean is(String propertyKey) {
        String value = this.get(propertyKey);
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectiveProperties)) {
            return false;
        }
        ObjectiveProperties another = (ObjectiveProperties)obj;
        if (this._javaPropertiesResult == null) {
            return another._javaPropertiesResult == null;
        }
        return this._javaPropertiesResult.equals(another._javaPropertiesResult);
    }

    public int hashCode() {
        return this._javaPropertiesResult != null ? this._javaPropertiesResult.hashCode() : 0;
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._javaPropertiesResult + "}";
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    public List<String> getExtendsResourcePathList() {
        return this._extendsResourcePathList;
    }

    public boolean isCheckImplicitOverride() {
        return this._checkImplicitOverride;
    }

    public JavaPropertiesResult getJavaPropertiesResult() {
        return this._javaPropertiesResult;
    }
}

