/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.jprop;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dbflute.helper.jprop.JavaPropertiesProperty;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;

public class JavaPropertiesResult {
    protected final Properties _plainProp;
    protected final List<JavaPropertiesProperty> _propertyList;
    protected final Map<String, JavaPropertiesProperty> _propertyMap;
    protected final List<JavaPropertiesProperty> _propertyBasePointOnlyList;
    protected final List<JavaPropertiesProperty> _propertyExtendsOnlyList;
    protected final List<String> _duplicateKeyList;
    protected final JavaPropertiesResult _extendsPropResult;

    public JavaPropertiesResult(Properties plainProp, List<JavaPropertiesProperty> propertyList, List<String> duplicateKeyList) {
        this(plainProp, propertyList, duplicateKeyList, null);
    }

    public JavaPropertiesResult(Properties plainProp, List<JavaPropertiesProperty> propertyList, List<String> duplicateKeyList, JavaPropertiesResult extendsPropResult) {
        this._plainProp = plainProp;
        this._propertyList = propertyList;
        this._propertyMap = DfCollectionUtil.newLinkedHashMapSized(propertyList.size());
        this._propertyBasePointOnlyList = DfCollectionUtil.newArrayList();
        this._propertyExtendsOnlyList = DfCollectionUtil.newArrayList();
        for (JavaPropertiesProperty property : propertyList) {
            this._propertyMap.put(property.getPropertyKey(), property);
            if (property.isExtends()) {
                this._propertyExtendsOnlyList.add(property);
                continue;
            }
            this._propertyBasePointOnlyList.add(property);
        }
        this._duplicateKeyList = duplicateKeyList;
        this._extendsPropResult = extendsPropResult;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JavaPropertiesResult)) {
            return false;
        }
        JavaPropertiesResult another = (JavaPropertiesResult)obj;
        return this._propertyList.equals(another._propertyList);
    }

    public int hashCode() {
        return this._propertyList.hashCode();
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._propertyMap.keySet() + "}";
    }

    public Properties getPlainProp() {
        return this._plainProp;
    }

    public JavaPropertiesProperty getProperty(String propertyKey) {
        return this._propertyMap.get(propertyKey);
    }

    public List<JavaPropertiesProperty> getPropertyList() {
        return this._propertyList;
    }

    public Map<String, JavaPropertiesProperty> getPropertyMap() {
        return this._propertyMap;
    }

    public List<JavaPropertiesProperty> getPropertyBasePointOnlyList() {
        return this._propertyBasePointOnlyList;
    }

    public List<JavaPropertiesProperty> getPropertyExtendsOnlyList() {
        return this._propertyExtendsOnlyList;
    }

    public List<String> getDuplicateKeyList() {
        return this._duplicateKeyList;
    }

    public JavaPropertiesResult getExtendsPropResult() {
        return this._extendsPropResult;
    }
}

