/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.dfmap;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.helper.dfmap.exception.DfMapDuplicateEntryException;
import org.dbflute.helper.dfmap.exception.DfMapParseFailureException;
import org.dbflute.helper.message.ExceptionMessageBuilder;

public class DfMapStyle {
    public static final String MAP_PREFIX = "map:";
    public static final String LIST_PREFIX = "list:";
    public static final String BEGIN_BRACE = "{";
    public static final String END_BRACE = "}";
    public static final String ELEMENT_DELIMITER = ";";
    public static final String VALUE_EQUAL = "=";
    protected static final String ESCAPE_CHAR = "\\";
    protected static final String ESCAPED_ESCAPE_MARK = "$$df:escapedEscape$$";
    protected final String _mapPrefix;
    protected final String _listPrefix;
    protected final String _beginBrace;
    protected final String _endBrace;
    protected final String _elementDelimiter;
    protected final String _valueEqual;
    protected final String _escapeChar;
    protected final String _mappingBeginBrace;
    protected final String _listingBeginBrace;
    protected String _remainderString;
    protected int _currentRemainderIndex;
    protected boolean _checkDuplicateEntry;
    protected boolean _printOneLiner;

    public DfMapStyle() {
        this(MAP_PREFIX, LIST_PREFIX, BEGIN_BRACE, END_BRACE, ELEMENT_DELIMITER, VALUE_EQUAL, ESCAPE_CHAR);
    }

    protected DfMapStyle(String mapPrefix, String listPrefix, String beginBrace, String endBrace, String elementDelimiter, String valueEqual, String escapeChar) {
        this.assertStringNotNullAndNotTrimmedEmpty("mapPrefix", mapPrefix);
        this.assertStringNotNullAndNotTrimmedEmpty("listPrefix", listPrefix);
        this.assertStringNotNullAndNotTrimmedEmpty("beginBrace", beginBrace);
        this.assertStringNotNullAndNotTrimmedEmpty("endBrace", endBrace);
        this.assertStringNotNullAndNotTrimmedEmpty("delimiter", elementDelimiter);
        this.assertStringNotNullAndNotTrimmedEmpty("valueEqual", valueEqual);
        this.assertStringNotNullAndNotTrimmedEmpty("escapeChar", escapeChar);
        this._mapPrefix = mapPrefix;
        this._listPrefix = listPrefix;
        this._beginBrace = beginBrace;
        this._endBrace = endBrace;
        this._elementDelimiter = elementDelimiter;
        this._valueEqual = valueEqual;
        this._escapeChar = escapeChar;
        this._mappingBeginBrace = this._mapPrefix + this._beginBrace;
        this._listingBeginBrace = this._listPrefix + this._beginBrace;
    }

    public DfMapStyle checkDuplicateEntry() {
        this._checkDuplicateEntry = true;
        return this;
    }

    public DfMapStyle printOneLiner() {
        this._printOneLiner = true;
        return this;
    }

    public String toMapString(Map<String, ? extends Object> map) {
        this.assertObjectNotNull("map", map);
        StringBuilder sb = new StringBuilder();
        Map<String, Object> casted = map;
        boolean printOneLiner = this.isPrintOneLiner();
        this.buildMapString(sb, casted, printOneLiner, "", printOneLiner ? "" : "    ");
        return sb.toString();
    }

    protected void buildMapString(StringBuilder sb, Map<String, Object> map, boolean printOneLiner, String previousIndent, String currentIndent) {
        this.doBuildMapStringBegin(sb, map, printOneLiner, previousIndent, currentIndent);
        if (!map.isEmpty()) {
            int index = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.doBuildMapStringCurrentEntry(sb, printOneLiner, previousIndent, currentIndent, index, entry.getKey(), entry.getValue());
                ++index;
            }
            if (printOneLiner) {
                sb.append(" ");
            } else {
                sb.append(this.ln()).append(previousIndent);
            }
        }
        this.doBuildMapStringEnd(sb, map, printOneLiner, previousIndent, currentIndent);
    }

    protected void doBuildMapStringBegin(StringBuilder sb, Map<String, Object> map, boolean printOneLiner, String previousIndent, String currentIndent) {
        sb.append(this._mapPrefix).append(this._beginBrace);
    }

    protected void doBuildMapStringCurrentEntry(StringBuilder sb, boolean printOneLiner, String previousIndent, String currentIndent, int index, String key, Object value) {
        if (printOneLiner) {
            if (index > 0) {
                sb.append(" ").append(this._elementDelimiter);
            }
        } else {
            sb.append(this.ln()).append(currentIndent).append(this._elementDelimiter);
        }
        sb.append(" ").append(this.escapeControlMarkAsMap(key)).append(" ").append(this._valueEqual).append(" ");
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
            this.buildMapString(sb, valueMap, printOneLiner, currentIndent, nextIndent);
        } else if (value instanceof List) {
            List valueList = (List)value;
            String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
            this.buildListString(sb, valueList, printOneLiner, currentIndent, nextIndent);
        } else {
            Map<String, Object> resolvedMap = this.resolvePotentialMapOfBuildingMapString(value);
            if (resolvedMap != null) {
                String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
                this.buildMapString(sb, resolvedMap, printOneLiner, currentIndent, nextIndent);
            } else {
                sb.append(this.escapeControlMarkAsMap(value));
            }
        }
    }

    protected void doBuildMapStringEnd(StringBuilder sb, Map<String, Object> map, boolean printOneLiner, String previousIndent, String currentIndent) {
        sb.append(this._endBrace);
    }

    public String toListString(List<? extends Object> list) {
        this.assertObjectNotNull("list", list);
        StringBuilder sb = new StringBuilder();
        List<? extends Object> casted = list;
        boolean printOneLiner = this.isPrintOneLiner();
        this.buildListString(sb, casted, printOneLiner, "", printOneLiner ? "" : "    ");
        return sb.toString();
    }

    protected void buildListString(StringBuilder sb, List<? extends Object> list, boolean printOneLiner, String previousIndent, String currentIndent) {
        this.doBuildListStringBegin(sb, list, printOneLiner, previousIndent, currentIndent);
        if (!list.isEmpty()) {
            int index = 0;
            for (Object object : list) {
                this.doBuildListStringCurrentElement(sb, printOneLiner, previousIndent, currentIndent, index, object);
                ++index;
            }
            if (printOneLiner) {
                sb.append(" ");
            } else {
                sb.append(this.ln()).append(previousIndent);
            }
        }
        this.doBuildListStringEnd(sb, list, printOneLiner, previousIndent, currentIndent);
    }

    protected void doBuildListStringBegin(StringBuilder sb, List<? extends Object> list, boolean printOneLiner, String previousIndent, String currentIndent) {
        sb.append(this._listPrefix).append(this._beginBrace);
    }

    protected void doBuildListStringCurrentElement(StringBuilder sb, boolean printOneLiner, String previousIndent, String currentIndent, int index, Object value) {
        if (printOneLiner) {
            if (index > 0) {
                sb.append(" ").append(this._elementDelimiter);
            }
        } else {
            sb.append(this.ln()).append(currentIndent).append(this._elementDelimiter);
        }
        sb.append(" ");
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
            this.buildMapString(sb, valueMap, printOneLiner, currentIndent, nextIndent);
        } else if (value instanceof List) {
            List valueList = (List)value;
            String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
            this.buildListString(sb, valueList, printOneLiner, currentIndent, nextIndent);
        } else {
            Map<String, Object> resolvedMap = this.resolvePotentialMapOfBuildingMapString(value);
            if (resolvedMap != null) {
                String nextIndent = this.deriveNextIndentOfBuildingMapString(printOneLiner, previousIndent, currentIndent);
                this.buildMapString(sb, resolvedMap, printOneLiner, currentIndent, nextIndent);
            } else {
                sb.append(this.escapeControlMarkAsList(value));
            }
        }
    }

    protected void doBuildListStringEnd(StringBuilder sb, List<? extends Object> list, boolean printOneLiner, String previousIndent, String currentIndent) {
        sb.append(this._endBrace);
    }

    protected String deriveNextIndentOfBuildingMapString(boolean printOneLiner, String previousIndent, String currentIndent) {
        return printOneLiner ? "" : this.generally_calculateNextIndent(previousIndent, currentIndent);
    }

    protected Map<String, Object> resolvePotentialMapOfBuildingMapString(Object value) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> fromMapString(String mapString) {
        this.assertStringNotNullAndNotTrimmedEmpty("mapString", mapString);
        this.beginRemainder(mapString);
        try {
            this.assertFirstMapString();
            this.ltrimRemainder();
            this.removePrefixMapingBeginBrace();
            Map<String, Object> map = this.newStringObjectMap();
            this.parseMapString(map);
            this.assertLastRemainderAsMap(map);
            Map<String, Object> map2 = map;
            return map2;
        }
        finally {
            this.endRemainder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> fromListString(String listString) {
        this.assertStringNotNullAndNotTrimmedEmpty("listString", listString);
        this.beginRemainder(listString);
        try {
            this.assertFirstListString();
            this.ltrimRemainder();
            this.removePrefixListingBeginBrace();
            List<Object> list = this.newObjectList();
            this.parseListString(list);
            this.assertLastRemainderAsList(list);
            List<Object> list2 = list;
            return list2;
        }
        finally {
            this.endRemainder();
        }
    }

    protected void parseMapString(Map<String, Object> currentMap) {
        String mapValue;
        int endBraceIndex;
        String mapKey;
        while (true) {
            if (!this.prepareLoopBeginning()) {
                return;
            }
            int equalIndex = this.indexOfEqual();
            this.assertMapStringEqualIndex(equalIndex, currentMap);
            mapKey = this.substringRemainderFront(equalIndex);
            this.removePrefixTargetIndexPlus(equalIndex, this._valueEqual.length());
            this.ltrimRemainder();
            if (this.startsWithMapBeginBrace()) {
                this.removePrefixMapingBeginBrace();
                this.parseMapString(this.setupNestMap(currentMap, mapKey));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            if (this.startsWithListBeginBrace()) {
                this.removePrefixListingBeginBrace();
                this.parseListString(this.setupNestList(currentMap, mapKey));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this.indexOfDelimiter();
            endBraceIndex = this.indexOfEndBrace();
            this.assertMapStringEndBraceIndex(endBraceIndex, currentMap);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            mapValue = this.substringRemainderFront(delimiterIndex);
            this.registerToMap(currentMap, this.filterParsedMapKey(mapKey), this.filterParsedMapValue(mapValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._elementDelimiter.length());
        }
        mapValue = this.substringRemainderScope(this._currentRemainderIndex, endBraceIndex);
        this.registerToMap(currentMap, this.filterParsedMapKey(mapKey), this.filterParsedMapValue(mapValue));
        this.closeByEndBraceIndex(endBraceIndex);
    }

    protected void parseListString(List<Object> currentList) {
        String listValue;
        int endBraceIndex;
        while (true) {
            if (!this.prepareLoopBeginning()) {
                return;
            }
            if (this.startsWithMapBeginBrace()) {
                this.removePrefixMapingBeginBrace();
                this.parseMapString(this.setupNestMap(currentList));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            if (this.startsWithListBeginBrace()) {
                this.removePrefixListingBeginBrace();
                this.parseListString(this.setupNestList(currentList));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this.indexOfDelimiter();
            endBraceIndex = this.indexOfEndBrace();
            this.assertListStringEndBraceIndex(endBraceIndex, currentList);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            listValue = this.substringRemainderFront(delimiterIndex);
            currentList.add(this.filterParsedListValue(listValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._elementDelimiter.length());
        }
        listValue = this.substringRemainderFront(endBraceIndex);
        currentList.add(this.filterParsedListValue(listValue));
        this.closeByEndBraceIndex(endBraceIndex);
    }

    protected boolean prepareLoopBeginning() {
        this.removePrefixAllDelimiter();
        if (this.isRemainderOver()) {
            return false;
        }
        if (this.startsWithEndBrace()) {
            this.removePrefixEndBrace();
            return false;
        }
        return true;
    }

    protected boolean closeAfterParseNestMapList() {
        if (this.startsWithEndBrace()) {
            this.removePrefixEndBrace();
            return true;
        }
        return false;
    }

    protected void closeByEndBraceIndex(int endBraceIndex) {
        this._currentRemainderIndex = endBraceIndex;
        this.removePrefixEndBrace();
    }

    protected int indexOfStartBrace() {
        return this.findIndexOfControlMark(this._beginBrace);
    }

    protected int indexOfEndBrace() {
        return this.findIndexOfControlMark(this._endBrace);
    }

    protected int indexOfDelimiter() {
        return this.findIndexOfControlMark(this._elementDelimiter);
    }

    protected int indexOfEqual() {
        return this.findIndexOfControlMark(this._valueEqual);
    }

    protected int findIndexOfControlMark(String controlMark) {
        int index;
        String current = this._remainderString;
        if (this.isEscapeCharEscape()) {
            String escapedEscapeChar = this.convertToEscapedMark(this._escapeChar);
            current = this.generally_replace(current, escapedEscapeChar, this.convertToLengthSpace(escapedEscapeChar));
        }
        int currentBeginIndex = this._currentRemainderIndex;
        while (true) {
            int nextIndex;
            String lastChar;
            if ((index = current.indexOf(controlMark, currentBeginIndex)) < 0) {
                return index;
            }
            if (index <= 0 || !this._escapeChar.equals(lastChar = current.substring(index - 1, index))) break;
            currentBeginIndex = nextIndex = index + this._escapeChar.length();
        }
        return index;
    }

    protected String convertToLengthSpace(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected void removePrefixAllDelimiter() {
        this.ltrimRemainder();
        while (this.startsWithDelimiter()) {
            if (!this.startsWithDelimiter()) continue;
            this.removePrefixDelimiter();
            this.ltrimRemainder();
        }
    }

    protected void removePrefixMapingBeginBrace() {
        this.doRemovePrefix(this._mappingBeginBrace);
    }

    protected void removePrefixListingBeginBrace() {
        this.doRemovePrefix(this._listingBeginBrace);
    }

    protected void removePrefixEndBrace() {
        this.doRemovePrefix(this._endBrace);
    }

    protected void removePrefixDelimiter() {
        this.doRemovePrefix(this._elementDelimiter);
    }

    protected void doRemovePrefix(String prefixString) {
        this.assertRemovingPrefix(prefixString);
        int nonTrimmedIndex = this.indexOfRemainderNonTrimmedChar();
        this._currentRemainderIndex = nonTrimmedIndex + prefixString.length();
    }

    protected void removePrefixTargetIndexPlus(int index, int plusCount) {
        this._currentRemainderIndex = index + plusCount;
    }

    protected boolean startsWithMapBeginBrace() {
        int index = this.indexOfRemainderNonTrimmedChar();
        return index >= 0 && this._remainderString.startsWith(this._mappingBeginBrace, index);
    }

    protected boolean startsWithListBeginBrace() {
        int index = this.indexOfRemainderNonTrimmedChar();
        return index >= 0 && this._remainderString.startsWith(this._listingBeginBrace, index);
    }

    protected boolean startsWithDelimiter() {
        int index = this.indexOfRemainderNonTrimmedChar();
        return index >= 0 && this._remainderString.startsWith(this._elementDelimiter, index);
    }

    protected boolean startsWithEndBrace() {
        int index = this.indexOfRemainderNonTrimmedChar();
        return index >= 0 && this._remainderString.startsWith(this._endBrace, index);
    }

    protected boolean startsWithPrefix(String prefix) {
        int index = this.indexOfRemainderNonTrimmedChar();
        return index >= 0 && this._remainderString.startsWith(prefix, index);
    }

    protected boolean endsWithEndBrace() {
        return this.generally_endsWith(this._remainderString, this._endBrace);
    }

    protected void registerToMap(Map<String, Object> currentMap, String key, Object element) {
        if (this.isCheckDuplicateEntry()) {
            this.assertDuplicateEntryInMap(currentMap, key, element);
        }
        currentMap.put(key, element);
    }

    protected void assertDuplicateEntryInMap(Map<String, Object> currentMap, String key, Object element) {
        if (currentMap.containsKey(key)) {
            this.throwDfMapDuplicateEntryException(currentMap, key, element);
        }
    }

    protected void throwDfMapDuplicateEntryException(Map<String, Object> currentMap, String key, Object element) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Duplicate entry in the map string.");
        br.addItem("Already Registered Entry");
        br.addElement(key);
        br.addElement(currentMap.get(key));
        br.addItem("New Duplicate Entry");
        br.addElement(key);
        if (element instanceof Map) {
            Map map = (Map)element;
            if (!map.isEmpty()) {
                br.addElement(map);
            }
        } else {
            br.addElement(element);
        }
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapDuplicateEntryException(msg);
    }

    protected Map<String, Object> setupNestMap(Map<String, Object> currentMap, String mapKey) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        this.registerToMap(currentMap, this.filterParsedMapKey(mapKey), nestMap);
        return nestMap;
    }

    protected Map<String, Object> setupNestMap(List<Object> currentList) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        currentList.add(nestMap);
        return nestMap;
    }

    protected List<Object> setupNestList(Map<String, Object> currentMap, String mapKey) {
        List<Object> nestList = this.newObjectList();
        this.registerToMap(currentMap, this.filterParsedMapKey(mapKey), nestList);
        return nestList;
    }

    protected List<Object> setupNestList(List<Object> currentList) {
        List<Object> nestList = this.newObjectList();
        currentList.add(nestList);
        return nestList;
    }

    protected String filterParsedMapKey(String value) {
        if (value == null) {
            return null;
        }
        String unescaped = this.unescapeControlMarkAsMap(value.trim());
        return this.doFilterParsedMapListNullExpression(unescaped);
    }

    protected String filterParsedMapValue(String value) {
        if (value == null) {
            return null;
        }
        String unescaped = this.unescapeControlMarkAsMap(value.trim());
        return this.doFilterParsedMapListNullExpression(unescaped);
    }

    protected String filterParsedListValue(String value) {
        if (value == null) {
            return null;
        }
        String unescaped = this.unescapeControlMarkAsList(value.trim());
        return this.doFilterParsedMapListNullExpression(unescaped);
    }

    protected String doFilterParsedMapListNullExpression(String filtered) {
        return "".equals(filtered) || "null".equals(filtered) ? null : filtered;
    }

    public Map<String, Object> newStringObjectMap() {
        return new LinkedHashMap<String, Object>();
    }

    public List<Object> newObjectList() {
        return new ArrayList<Object>();
    }

    public String escapeControlMarkAsMap(Object value) {
        return this.doEscapeControlMark(value, false);
    }

    public String escapeControlMarkAsList(Object value) {
        return this.doEscapeControlMark(value, this.isIgnoreEqualAsEscapeControlMarkInList());
    }

    protected boolean isIgnoreEqualAsEscapeControlMarkInList() {
        return false;
    }

    protected String doEscapeControlMark(Object value, boolean ignoreEqual) {
        if (value == null) {
            return null;
        }
        String filtered = value.toString();
        if (this.isEscapeCharEscape()) {
            filtered = this.generally_replace(filtered, this._escapeChar, this.convertToEscapedMark(this._escapeChar));
        }
        filtered = this.generally_replace(filtered, this._beginBrace, this.convertToEscapedMark(this._beginBrace));
        filtered = this.generally_replace(filtered, this._endBrace, this.convertToEscapedMark(this._endBrace));
        filtered = this.generally_replace(filtered, this._elementDelimiter, this.convertToEscapedMark(this._elementDelimiter));
        if (!ignoreEqual) {
            filtered = this.generally_replace(filtered, this._valueEqual, this.convertToEscapedMark(this._valueEqual));
        }
        return filtered;
    }

    public String unescapeControlMarkAsMap(String value) {
        return this.doUnescapeControlMark(value, false);
    }

    public String unescapeControlMarkAsList(String value) {
        return this.doUnescapeControlMark(value, this.isIgnoreEqualAsUnescapeControlMarkInList());
    }

    protected boolean isIgnoreEqualAsUnescapeControlMarkInList() {
        return false;
    }

    protected String doUnescapeControlMark(String value, boolean ignoreEqual) {
        if (value == null) {
            return null;
        }
        String filtered = value;
        String escapedEscapeMark = ESCAPED_ESCAPE_MARK;
        if (this.isEscapeCharEscape()) {
            filtered = this.generally_replace(filtered, this.convertToEscapedMark(this._escapeChar), ESCAPED_ESCAPE_MARK);
        }
        filtered = this.generally_replace(filtered, this.convertToEscapedMark(this._beginBrace), this._beginBrace);
        filtered = this.generally_replace(filtered, this.convertToEscapedMark(this._endBrace), this._endBrace);
        filtered = this.generally_replace(filtered, this.convertToEscapedMark(this._elementDelimiter), this._elementDelimiter);
        if (!ignoreEqual) {
            filtered = this.generally_replace(filtered, this.convertToEscapedMark(this._valueEqual), this._valueEqual);
        }
        if (this.isEscapeCharEscape()) {
            filtered = this.generally_replace(filtered, ESCAPED_ESCAPE_MARK, this._escapeChar);
        }
        return filtered;
    }

    protected String convertToEscapedMark(String mark) {
        return this._escapeChar + mark;
    }

    protected boolean isEscapeCharEscape() {
        return false;
    }

    protected void assertFirstMapString() {
        if (this._remainderString == null) {
            this.throwDfMapStringBasicFailureException("The map-string should not be null.");
        }
        if (!this.startsWithMapBeginBrace()) {
            this.throwDfMapStringBasicFailureException("The map-string should start with '" + this._mappingBeginBrace + "'.");
        }
        if (!this.endsWithEndBrace()) {
            this.throwDfMapStringBasicFailureException("The map-string should end with '" + this._endBrace + "'.");
        }
    }

    protected void throwDfMapStringBasicFailureException(String notice) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void throwDfMapStringDifferentCountBracesException(int beginCount, int endCount) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Different count between begin braces and end braces.");
        br.addItem("Advice");
        br.addElement("Make sure braces on your map-string.");
        br.addElement("For example:");
        br.addElement("  (x): map:{ sea = ");
        br.addElement("  (x): map:{ sea = map:{ }");
        br.addElement("  (o): map:{ sea = land }");
        br.addElement("  (o): map:{ sea = map:{ land = piari } }");
        br.addElement("");
        br.addElement("While, map-string can escape control marks");
        br.addElement("so pay attention to last char of value like this:");
        br.addElement("  (x): map:{ sea = C:\\land\\piari\\}  // last '}' escaped by escape char");
        br.addElement("  (o): map:{ sea = C:\\land\\piari\\ } // space helps you at the case");
        br.addItem("Brace Count");
        br.addElement("begin: " + beginCount);
        br.addElement("end: " + endCount);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertFirstListString() {
        if (this._remainderString == null) {
            this.throwListStringBasicFailureException("The list string should not be null.");
        }
        if (!this.startsWithListBeginBrace()) {
            this.throwListStringBasicFailureException("The list string should start with '" + this._listingBeginBrace + "'.");
        }
        if (!this.endsWithEndBrace()) {
            this.throwListStringBasicFailureException("The list string should end with '" + this._endBrace + "'.");
        }
    }

    protected void throwListStringBasicFailureException(String notice) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void throwDfListStringDifferentCountBracesException(int beginCount, int endCount) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Different count between begin braces and end braces.");
        br.addItem("Advice");
        br.addElement("Make sure braces on your list-string.");
        br.addElement("For example:");
        br.addElement("  (x): list:{ sea");
        br.addElement("  (x): list:{ sea ; map:{ }");
        br.addElement("  (o): list:{ sea ; land }");
        br.addElement("  (o): list:{ sea ; map:{ land = piari } }");
        br.addElement("");
        br.addElement("While, list-string can escape control marks");
        br.addElement("so pay attention to last char of value like this:");
        br.addElement("  (x): list:{ sea = C:\\land\\piari\\}  // last '}' escaped by escape char");
        br.addElement("  (o): list:{ sea = C:\\land\\piari\\ } // space helps you at the case");
        br.addItem("Brace Count");
        br.addElement("begin: " + beginCount);
        br.addElement("end: " + endCount);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertMapStringEqualIndex(int valueEqualIndex, Map<String, Object> currentMap) {
        String extractedMark;
        int logicalLength;
        String notice;
        if (this._remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwDfMapValueEqualFailureException("The remainderString should not be null:", valueEqualIndex, currentMap);
        }
        if (valueEqualIndex < 0) {
            notice = "Not found the value-equal mark in the map-string.";
            this.throwDfMapValueEqualFailureException("Not found the value-equal mark in the map-string.", valueEqualIndex, currentMap);
        }
        if ((logicalLength = this.lengthRemainder()) < this._remainderString.length() - valueEqualIndex) {
            String notice2 = "The remainderString length should be greater than equalIndex:";
            this.throwDfMapValueEqualFailureException("The remainderString length should be greater than equalIndex:", valueEqualIndex, currentMap);
        }
        if (!(extractedMark = this.substringRemainderScope(valueEqualIndex, valueEqualIndex + this._valueEqual.length())).equals(this._valueEqual)) {
            String notice3 = "The remainderString should have value-equal mark at value-equal index:";
            this.throwDfMapValueEqualFailureException("The remainderString should have value-equal mark at value-equal index:", valueEqualIndex, currentMap);
        }
    }

    protected void throwDfMapValueEqualFailureException(String notice, int valueEqualIndex, Map<String, Object> currentMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("ValueEqual Index");
        br.addElement(valueEqualIndex);
        br.addItem("Making Map");
        br.addElement(currentMap);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertMapStringEndBraceIndex(int endBraceIndex, Map<String, Object> makingMap) {
        int logicalLength;
        String notice;
        if (endBraceIndex < 0) {
            notice = "Not found the end-brace in the map-string.";
            this.throwDfMapStringEndBraceFailureException("Not found the end-brace in the map-string.", endBraceIndex, makingMap);
        }
        if (this._remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwDfMapStringEndBraceFailureException("The remainderString should not be null:", endBraceIndex, makingMap);
        }
        if ((logicalLength = this.lengthRemainder()) < this._remainderString.length() - endBraceIndex) {
            String notice2 = "The remainderString length should be greater than end-brace index:";
            this.throwDfMapStringEndBraceFailureException("The remainderString length should be greater than end-brace index:", endBraceIndex, makingMap);
        }
        this.substringRemainderScope(endBraceIndex, endBraceIndex + this._endBrace.length());
        String extractedMark = this.substringRemainderScope(endBraceIndex, endBraceIndex + this._endBrace.length());
        if (!extractedMark.equals(this._endBrace)) {
            String notice3 = "The remainderString should have end-brace at the end-brace index:";
            this.throwDfMapStringEndBraceFailureException("The remainderString should have end-brace at the end-brace index:", endBraceIndex, makingMap);
        }
    }

    protected void throwDfMapStringEndBraceFailureException(String notice, int endBraceIndex, Map<String, Object> currentMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("EndBrace Index");
        br.addElement(endBraceIndex);
        br.addItem("Making Map");
        br.addElement(currentMap);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertListStringEndBraceIndex(int endBraceIndex, List<?> makingList) {
        String extractedMark;
        int logicalLength;
        String notice;
        if (endBraceIndex < 0) {
            notice = "Not found the end brace.";
            this.throwDfListStringEndBraceFailureException("Not found the end brace.", endBraceIndex, makingList);
        }
        if (this._remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwDfListStringEndBraceFailureException("The remainderString should not be null:", endBraceIndex, makingList);
        }
        if ((logicalLength = this.lengthRemainder()) < this._remainderString.length() - endBraceIndex) {
            String notice2 = "The remainderString length should be greater than end-brace index:";
            this.throwDfListStringEndBraceFailureException("The remainderString length should be greater than end-brace index:", endBraceIndex, makingList);
        }
        if (!(extractedMark = this.substringRemainderScope(endBraceIndex, endBraceIndex + this._endBrace.length())).equals(this._endBrace)) {
            String notice3 = "The remainderString should have end-brace at the end-brace index:";
            this.throwDfListStringEndBraceFailureException("The remainderString should have end-brace at the end-brace index:", endBraceIndex, makingList);
        }
    }

    protected void throwDfListStringEndBraceFailureException(String notice, int endBraceIndex, List<?> makingList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("EndBrace Index");
        br.addElement(endBraceIndex);
        br.addItem("Making List");
        br.addElement(makingList);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertRemovingPrefix(String prefixString) {
        String notice;
        if (this._remainderString == null) {
            notice = "The remainderString should not be null.";
            this.throwDfMapRemovingPrefixFailureException("The remainderString should not be null.", prefixString);
        }
        if (prefixString == null) {
            notice = "The prefixString should not be null.";
            this.throwDfMapRemovingPrefixFailureException("The prefixString should not be null.", prefixString);
        }
        if (!this.startsWithPrefix(prefixString)) {
            notice = "The remainderString shuold start with the prefixString.";
            this.throwDfMapRemovingPrefixFailureException("The remainderString shuold start with the prefixString.", prefixString);
        }
    }

    protected void throwDfMapRemovingPrefixFailureException(String notice, String prefixString) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Prefix String");
        br.addElement(prefixString);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertLastRemainderAsMap(Map<String, Object> generatedMap) {
        if (this.indexOfRemainderNonTrimmedChar() >= 0) {
            this.throwDfMapStringUnneededStringFoundException(generatedMap);
        }
    }

    protected void throwDfMapStringUnneededStringFoundException(Map<String, Object> generatedMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The last remainderString as map should be empty string but ...");
        br.addItem("Generated Map");
        br.addElement(generatedMap);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void assertLastRemainderAsList(List<Object> generatedList) {
        if (this.indexOfRemainderNonTrimmedChar() >= 0) {
            this.throwDfListStringUnneededStringFoundException(generatedList);
        }
    }

    protected void throwDfListStringUnneededStringFoundException(List<Object> generatedList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The last remainderString as list should be empty string but ...");
        br.addItem("Generated List");
        br.addElement(generatedList);
        this.setupMessageRemainderString(br);
        String msg = br.buildExceptionMessage();
        throw new DfMapParseFailureException(msg);
    }

    protected void setupMessageRemainderString(ExceptionMessageBuilder br) {
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("Current Remainder Index");
        if (this._remainderString != null) {
            br.addElement(this._currentRemainderIndex + " (max:" + this._remainderString.length() + ")");
            if (this._currentRemainderIndex >= 0 && this._remainderString.length() >= this._currentRemainderIndex) {
                br.addElement(this.cut(this._remainderString.substring(this._currentRemainderIndex), 30, "..."));
            }
        } else {
            br.addElement(this._currentRemainderIndex);
        }
        br.addItem("Defined Control Mark");
        br.addElement(this._mapPrefix + " " + this._listPrefix + " " + this._beginBrace + " " + this._endBrace + " " + this._elementDelimiter + " " + this._valueEqual);
    }

    protected String cut(String str, int length, String suffix) {
        this.assertObjectNotNull("str", str);
        return str.length() > length ? str.substring(0, length) + (suffix != null ? suffix : "") : str;
    }

    protected void beginRemainder(String mapString) {
        this._remainderString = mapString;
        this._currentRemainderIndex = 0;
    }

    protected void endRemainder() {
        this._remainderString = null;
        this._currentRemainderIndex = 0;
    }

    protected int indexOfRemainderNonTrimmedChar() {
        return this.generally_indexOfNonTrimmedChar(this._remainderString, this._currentRemainderIndex);
    }

    protected boolean isRemainderOver() {
        if (this._remainderString.length() == this._currentRemainderIndex + 1) {
            return true;
        }
        return this.indexOfRemainderNonTrimmedChar() < 0;
    }

    protected int lengthRemainder() {
        return this._remainderString.length() - this._currentRemainderIndex;
    }

    protected void ltrimRemainder() {
        int index = this.indexOfRemainderNonTrimmedChar();
        if (index > 0) {
            this._currentRemainderIndex = index;
        }
    }

    protected String substringRemainderFront(int endIndex) {
        return this._remainderString.substring(this._currentRemainderIndex, endIndex);
    }

    protected String substringRemainderScope(int beginIndex, int endIndex) {
        return this._remainderString.substring(beginIndex, endIndex);
    }

    protected String generally_replace(String str, String fromStr, String toStr) {
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    protected boolean generally_endsWith(String str, String suffix) {
        int remainderIndex = this.generally_lastIndexOfNonTrimmedChar(str);
        int i = suffix.length() - 1;
        while (i >= 0) {
            char remainderCh;
            char branceCh = suffix.charAt(i);
            if (branceCh != (remainderCh = str.charAt(remainderIndex))) {
                return false;
            }
            --i;
            --remainderIndex;
        }
        return true;
    }

    protected int generally_indexOfNonTrimmedChar(String str, int offsetIndex) {
        for (int index = offsetIndex; index < str.length(); ++index) {
            char ch = str.charAt(index);
            if (ch <= ' ') continue;
            return index;
        }
        return -1;
    }

    protected int generally_lastIndexOfNonTrimmedChar(String str) {
        for (int index = str.length() - 1; index >= 0; --index) {
            char ch = str.charAt(index);
            if (ch <= ' ') continue;
            return index;
        }
        return -1;
    }

    protected String generally_calculateNextIndent(String previousIndent, String currentIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append(currentIndent);
        int indentLength = currentIndent.length() - previousIndent.length();
        for (int i = 0; i < indentLength; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String ln() {
        return "\n";
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public boolean isCheckDuplicateEntry() {
        return this._checkDuplicateEntry;
    }

    public boolean isPrintOneLiner() {
        return this._printOneLiner;
    }
}

