/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.dfmap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.dbflute.helper.dfmap.DfMapStyle;

public class DfMapFile {
    protected static final String UTF8_ENCODING = "UTF-8";
    public static final String LINE_COMMENT_MARK = "#";
    protected final String _fileEncoding;
    protected final String _lineCommentMark;
    protected boolean _skipLineSeparator;
    protected boolean _checkDuplicateEntry;

    public DfMapFile() {
        this(UTF8_ENCODING, LINE_COMMENT_MARK);
    }

    protected DfMapFile(String fileEncoding, String lineCommentMark) {
        this.assertStringNotNullAndNotTrimmedEmpty("fileEncoding", fileEncoding);
        this.assertStringNotNullAndNotTrimmedEmpty("lineCommentMark", lineCommentMark);
        this._fileEncoding = fileEncoding;
        this._lineCommentMark = lineCommentMark;
    }

    public DfMapFile skipLineSeparator() {
        this._skipLineSeparator = true;
        return this;
    }

    public DfMapFile checkDuplicateEntry() {
        this._checkDuplicateEntry = true;
        return this;
    }

    public Map<String, Object> readMap(InputStream ins) throws IOException {
        this.assertObjectNotNull("ins", ins);
        String mapString = this.readString(ins);
        DfMapStyle mapStyle = this.createMapStyle();
        if (mapString.trim().length() > 0) {
            return mapStyle.fromMapString(mapString);
        }
        return this.createResultMap(mapStyle);
    }

    public <VALUE> Map<String, VALUE> readMap(InputStream ins, Class<VALUE> valueType) throws IOException {
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("valueType", valueType);
        String mapString = this.readString(ins);
        DfMapStyle mapStyle = this.createMapStyle();
        if (mapString.trim().length() > 0) {
            Map<String, Object> plainMap = mapStyle.fromMapString(mapString);
            Map<String, Object> resultMap = this.createResultMap(mapStyle);
            for (Map.Entry<String, Object> entry : plainMap.entrySet()) {
                Object value = entry.getValue();
                resultMap.put(entry.getKey(), value != null ? (Object)valueType.cast(value) : null);
            }
            return resultMap;
        }
        Map<String, Object> emptyMap = this.createResultMap(mapStyle);
        return emptyMap;
    }

    public void writeMap(OutputStream ous, Map<String, ? extends Object> map) throws IOException {
        DfMapStyle mapStyle = this.createMapStyle();
        String mapString = mapStyle.toMapString(map);
        this.writeString(ous, mapString);
    }

    public List<Object> readList(InputStream ins) throws IOException {
        this.assertObjectNotNull("ins", ins);
        String listString = this.readString(ins);
        DfMapStyle mapStyle = this.createMapStyle();
        if (listString.trim().length() > 0) {
            return mapStyle.fromListString(listString);
        }
        return mapStyle.newObjectList();
    }

    public <ELEMENT> List<ELEMENT> readList(InputStream ins, Class<ELEMENT> elementType) throws IOException {
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("elementType", elementType);
        String listString = this.readString(ins);
        DfMapStyle mapStyle = this.createMapStyle();
        if (listString.trim().length() > 0) {
            List<Object> plainList = mapStyle.fromListString(listString);
            List<Object> resultList = this.createResultList(mapStyle);
            for (Object element : plainList) {
                resultList.add(element != null ? (Object)elementType.cast(element) : null);
            }
            return resultList;
        }
        List<Object> emptyList = this.createResultList(mapStyle);
        return emptyList;
    }

    public void writeList(OutputStream ous, List<? extends Object> list) throws IOException {
        DfMapStyle mapStyle = this.createMapStyle();
        String listString = mapStyle.toListString(list);
        this.writeString(ous, listString);
    }

    public String readString(InputStream ins) throws IOException {
        this.assertObjectNotNull("ins", ins);
        String encoding = this._fileEncoding;
        String lineCommentMark = this._lineCommentMark;
        StringBuilder sb = new StringBuilder();
        boolean addLn = !this._skipLineSeparator;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            ir = new InputStreamReader(ins, encoding);
            br = new BufferedReader(ir);
            int loopIndex = -1;
            int validlineCount = -1;
            boolean previousLineComment = false;
            while (true) {
                ++loopIndex;
                String lineString = br.readLine();
                if (lineString == null) {
                    if (previousLineComment && addLn) {
                        sb.append(this.ln());
                    }
                    break;
                }
                if (loopIndex == 0) {
                    lineString = this.removeInitialUnicodeBomIfNeeds(encoding, lineString);
                }
                if (lineString.trim().startsWith(lineCommentMark)) {
                    previousLineComment = true;
                    continue;
                }
                previousLineComment = false;
                if (++validlineCount > 0 && addLn) {
                    sb.append(this.ln());
                }
                sb.append(lineString);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public void writeString(OutputStream ous, String str) throws IOException {
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("str", str);
        String encoding = this._fileEncoding;
        OutputStreamWriter ow = null;
        BufferedWriter bw = null;
        try {
            ow = new OutputStreamWriter(ous, encoding);
            bw = new BufferedWriter(ow);
            bw.write(this.removeInitialUnicodeBomIfNeeds(encoding, str));
            bw.flush();
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected DfMapStyle createMapStyle() {
        DfMapStyle mapStyle = this.newMapStyle();
        if (this._checkDuplicateEntry) {
            mapStyle.checkDuplicateEntry();
        }
        return mapStyle;
    }

    protected DfMapStyle newMapStyle() {
        return new DfMapStyle();
    }

    protected Map<String, Object> createResultMap(DfMapStyle mapStyle) {
        return mapStyle.newStringObjectMap();
    }

    protected List<Object> createResultList(DfMapStyle mapStyle) {
        return mapStyle.newObjectList();
    }

    protected String removeInitialUnicodeBomIfNeeds(String encoding, String value) {
        if (UTF8_ENCODING.equalsIgnoreCase(encoding) && value.length() > 0 && value.charAt(0) == '\ufeff') {
            return value.substring(1);
        }
        return value;
    }

    protected String ln() {
        return "\n";
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }
}

