/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.core.command;

import java.util.Map;
import org.dbflute.bhv.core.SqlExecution;
import org.dbflute.bhv.core.SqlExecutionCreator;
import org.dbflute.bhv.core.command.AbstractOutsideSqlCommand;
import org.dbflute.bhv.core.context.FetchAssistContext;
import org.dbflute.bhv.core.execution.OutsideSqlSelectExecution;
import org.dbflute.cbean.paging.FetchNarrowingBean;
import org.dbflute.jdbc.FetchBean;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.outsidesql.OutsideSqlOption;
import org.dbflute.s2dao.jdbc.TnResultSetHandler;

public abstract class AbstractOutsideSqlSelectCommand<RESULT>
extends AbstractOutsideSqlCommand<RESULT> {
    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        OutsideSqlContext.setOutsideSqlContextOnThread(this.createOutsideSqlContext());
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        this.setupFetchBean(pmb, option);
    }

    @Override
    protected void setupOutsideSqlContextProperty(OutsideSqlContext outsideSqlContext) {
        super.setupOutsideSqlContextProperty(outsideSqlContext);
        OutsideSqlOption option = this._outsideSqlOption;
        boolean autoPagingLogging = option.isAutoPaging() || option.isSourcePagingRequestTypeAuto();
        outsideSqlContext.setAutoPagingLogging(autoPagingLogging);
    }

    protected void setupFetchBean(Object pmb, OutsideSqlOption option) {
        if (pmb == null) {
            return;
        }
        if (pmb instanceof FetchBean) {
            FetchAssistContext.setFetchBeanOnThread((FetchBean)pmb);
            if (pmb instanceof FetchNarrowingBean && option.isManualPaging()) {
                ((FetchNarrowingBean)pmb).xdisableFetchNarrowing();
            }
        }
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this.generateSpecifiedOutsideSqlUniqueKey();
    }

    protected String generateSpecifiedOutsideSqlUniqueKey() {
        String methodName = this.getCommandName();
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        Class<?> resultType = this.getResultType();
        return OutsideSqlContext.generateSpecifiedOutsideSqlUniqueKey(methodName, path, pmb, option, resultType);
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return () -> {
            OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
            return this.createOutsideSqlSelectExecution(outsideSqlContext);
        };
    }

    protected SqlExecution createOutsideSqlSelectExecution(OutsideSqlContext outsideSqlContext) {
        Object pmb = outsideSqlContext.getParameterBean();
        String suffix = this.buildDbmsSuffix();
        String sql = outsideSqlContext.readFilteredOutsideSql(this._sqlFileEncoding, suffix);
        TnResultSetHandler handler = this.createOutsideSqlSelectResultSetHandler();
        OutsideSqlSelectExecution execution = this.createOutsideSqlSelectExecution(pmb, sql, handler);
        execution.setRemoveBlockComment(this.isRemoveBlockComment(outsideSqlContext));
        execution.setRemoveLineComment(this.isRemoveLineComment(outsideSqlContext));
        execution.setFormatSql(outsideSqlContext.isFormatSql());
        execution.setOutsideSqlFilter(this._outsideSqlFilter);
        return execution;
    }

    protected abstract TnResultSetHandler createOutsideSqlSelectResultSetHandler();

    protected OutsideSqlSelectExecution createOutsideSqlSelectExecution(Object pmbTypeObj, String sql, TnResultSetHandler handler) {
        Map<String, Class<?>> argNameTypeMap = this.createBeanArgNameTypeMap(pmbTypeObj);
        return this.newOutsideSqlSelectExecution(argNameTypeMap, sql, handler);
    }

    protected OutsideSqlSelectExecution newOutsideSqlSelectExecution(Map<String, Class<?>> argNameTypeMap, String sql, TnResultSetHandler handler) {
        return new OutsideSqlSelectExecution(this._dataSource, this._statementFactory, argNameTypeMap, sql, handler);
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        this.assertStatus("getSqlExecutionArgument");
        return new Object[]{this._parameterBean};
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        this.assertOutsideSqlBasic(methodName);
    }
}

