/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.poi.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.impl.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataIndex;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class ExcelRecordReader
extends FileRecordReader {
    private boolean skippedLines = false;
    protected int skipNumLines = 0;
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    private Iterator<Sheet> sheetIterator;
    private Iterator<Row> rows;
    private DataFormatter dataFormatter = new DataFormatter();
    private Workbook currWorkBook;
    private int numColumns = -1;

    public ExcelRecordReader(int skipNumLines) {
        this.skipNumLines = skipNumLines;
    }

    public ExcelRecordReader() {
        this(0);
    }

    public boolean hasNext() {
        if (!this.skipLines()) {
            throw new NoSuchElementException("No next element found!");
        }
        return this.skipLines() && super.hasNext() || this.sheetIterator != null && this.sheetIterator.hasNext() || this.rows != null && this.rows.hasNext();
    }

    private boolean skipLines() {
        if (!this.skippedLines && this.skipNumLines > 0) {
            for (int i = 0; i < this.skipNumLines; ++i) {
                if (!super.hasNext()) {
                    return false;
                }
                super.next();
            }
            this.skippedLines = true;
        }
        return true;
    }

    public List<Writable> next() {
        return this.nextRecord().getRecord();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.datavec.api.records.Record nextRecord() {
        if (this.rows != null && this.rows.hasNext()) {
            Row currRow = this.rows.next();
            ArrayList<Text> ret = new ArrayList<Text>(currRow.getLastCellNum());
            Iterator iterator = currRow.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return new Record(ret, (RecordMetaData)new RecordMetaDataIndex((long)currRow.getRowNum(), this.currentUri, ExcelRecordReader.class));
                }
                Cell cell = (Cell)iterator.next();
                String cellValue = this.dataFormatter.formatCellValue(cell);
                ret.add(new Text(cellValue));
            }
        }
        if (this.sheetIterator != null && this.sheetIterator.hasNext()) {
            Sheet sheet = this.sheetIterator.next();
            this.rows = sheet.rowIterator();
            Row currRow = this.rows.next();
            return new Record(this.rowToRecord(currRow), (RecordMetaData)new RecordMetaDataIndex((long)currRow.getRowNum(), this.currentUri, ExcelRecordReader.class));
        }
        try {
            Throwable throwable = null;
            try (InputStream is = (InputStream)this.streamCreatorFn.apply(this.locationsIterator.next());){
                Record record;
                if (this.currWorkBook != null) {
                    this.currWorkBook.close();
                }
                this.currWorkBook = WorkbookFactory.create((InputStream)is);
                this.sheetIterator = this.currWorkBook.sheetIterator();
                Sheet sheet = this.sheetIterator.next();
                this.rows = sheet.rowIterator();
                Row currRow = this.rows.next();
                Record record2 = record = new Record(this.rowToRecord(currRow), (RecordMetaData)new RecordMetaDataIndex((long)currRow.getRowNum(), this.currentUri, ExcelRecordReader.class));
                return record2;
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException("Error processing row", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stream", e);
        }
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, 0);
    }

    public void reset() {
        super.reset();
        this.skippedLines = false;
    }

    private List<Writable> rowToRecord(Row currRow) {
        if (this.numColumns < 0) {
            this.numColumns = currRow.getLastCellNum();
        }
        if (currRow.getLastCellNum() != this.numColumns) {
            throw new IllegalStateException("Invalid number of columns for row. First number of columns found was " + this.numColumns + " but row " + currRow.getRowNum() + " was " + currRow.getLastCellNum());
        }
        ArrayList<Writable> ret = new ArrayList<Writable>(currRow.getLastCellNum());
        block6: for (Cell cell : currRow) {
            String cellValue = this.dataFormatter.formatCellValue(cell);
            switch (cell.getCellType()) {
                case BLANK: {
                    ret.add((Writable)new Text(""));
                    continue block6;
                }
                case STRING: {
                    ret.add((Writable)new Text(""));
                    continue block6;
                }
                case BOOLEAN: {
                    ret.add((Writable)new BooleanWritable(Boolean.valueOf(cellValue).booleanValue()));
                    continue block6;
                }
                case NUMERIC: {
                    ret.add((Writable)new DoubleWritable(Double.parseDouble(cellValue)));
                    continue block6;
                }
            }
            ret.add((Writable)new Text(cellValue));
        }
        return ret;
    }
}

