/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.io.IOUtils;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.leptonica.PIX;
import org.bytedeco.leptonica.PIXA;
import org.bytedeco.leptonica.global.lept;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Size;
import org.datavec.image.data.Image;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.loader.AndroidNativeImageLoader;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.loader.Java2DNativeImageLoader;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;
import org.opencv.core.Mat;

public class NativeImageLoader
extends BaseImageLoader {
    private static final int MIN_BUFFER_STEP_SIZE = 65536;
    private byte[] buffer = null;
    private org.bytedeco.opencv.opencv_core.Mat bufferMat = null;
    public static final String[] ALLOWED_FORMATS = new String[]{"bmp", "gif", "jpg", "jpeg", "jp2", "pbm", "pgm", "ppm", "pnm", "png", "tif", "tiff", "exr", "webp", "BMP", "GIF", "JPG", "JPEG", "JP2", "PBM", "PGM", "PPM", "PNM", "PNG", "TIF", "TIFF", "EXR", "WEBP"};
    protected OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();
    boolean direct = !Loader.getPlatform().startsWith("android");

    public NativeImageLoader() {
    }

    public NativeImageLoader(long height, long width) {
        this.height = height;
        this.width = width;
    }

    public NativeImageLoader(long height, long width, long channels) {
        this.height = height;
        this.width = width;
        this.channels = channels;
    }

    public NativeImageLoader(long height, long width, long channels, boolean centerCropIfNeeded) {
        this(height, width, channels);
        this.centerCropIfNeeded = centerCropIfNeeded;
    }

    public NativeImageLoader(long height, long width, long channels, ImageTransform imageTransform) {
        this(height, width, channels);
        this.imageTransform = imageTransform;
    }

    public NativeImageLoader(long height, long width, long channels, BaseImageLoader.MultiPageMode mode) {
        this(height, width, channels);
        this.multiPageMode = mode;
    }

    protected NativeImageLoader(NativeImageLoader other) {
        this.height = other.height;
        this.width = other.width;
        this.channels = other.channels;
        this.centerCropIfNeeded = other.centerCropIfNeeded;
        this.imageTransform = other.imageTransform;
        this.multiPageMode = other.multiPageMode;
    }

    @Override
    public String[] getAllowedFormats() {
        return ALLOWED_FORMATS;
    }

    public INDArray asRowVector(String filename) throws IOException {
        return this.asRowVector(new File(filename));
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        return this.asMatrix(f).ravel();
    }

    @Override
    public INDArray asRowVector(InputStream is) throws IOException {
        return this.asMatrix(is).ravel();
    }

    public INDArray asRowVector(Object image) throws IOException {
        return this.asMatrix(image).ravel();
    }

    public INDArray asRowVector(Frame image) throws IOException {
        return this.asMatrix(image).ravel();
    }

    public INDArray asRowVector(org.bytedeco.opencv.opencv_core.Mat image) throws IOException {
        INDArray arr = this.asMatrix(image);
        return arr.reshape('c', new long[]{1L, arr.length()});
    }

    public INDArray asRowVector(Mat image) throws IOException {
        INDArray arr = this.asMatrix(image);
        return arr.reshape('c', new long[]{1L, arr.length()});
    }

    static org.bytedeco.opencv.opencv_core.Mat convert(PIX pix) {
        org.bytedeco.opencv.opencv_core.Mat mat2;
        PIX tempPix = null;
        int dtype = -1;
        int height = pix.h();
        int width = pix.w();
        if (pix.colormap() != null) {
            PIX pix2;
            tempPix = pix = (pix2 = lept.pixRemoveColormap((PIX)pix, (int)2));
            dtype = opencv_core.CV_8UC4;
        } else if (pix.d() <= 8 || pix.d() == 24) {
            PIX pix2 = null;
            switch (pix.d()) {
                case 1: {
                    pix2 = lept.pixConvert1To8(null, (PIX)pix, (byte)0, (byte)-1);
                    break;
                }
                case 2: {
                    pix2 = lept.pixConvert2To8((PIX)pix, (byte)0, (byte)85, (byte)-86, (byte)-1, (int)0);
                    break;
                }
                case 4: {
                    pix2 = lept.pixConvert4To8((PIX)pix, (int)0);
                    break;
                }
                case 8: {
                    pix2 = pix;
                    break;
                }
                case 24: {
                    pix2 = pix;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            tempPix = pix = pix2;
            int channels = pix.d() / 8;
            dtype = opencv_core.CV_8UC((int)channels);
            org.bytedeco.opencv.opencv_core.Mat mat = new org.bytedeco.opencv.opencv_core.Mat(height, width, dtype, (Pointer)pix.data(), (long)(4 * pix.wpl()));
            mat2 = new org.bytedeco.opencv.opencv_core.Mat(height, width, opencv_core.CV_8UC((int)channels));
            int[] swap = new int[]{0, channels - 1, 1, channels - 2, 2, channels - 3, 3, channels - 4};
            int[] copy = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
            int[] fromTo = channels > 1 && ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? swap : copy;
            opencv_core.mixChannels((org.bytedeco.opencv.opencv_core.Mat)mat, (long)1L, (org.bytedeco.opencv.opencv_core.Mat)mat2, (long)1L, (int[])fromTo, (long)Math.min(channels, fromTo.length / 2));
        } else if (pix.d() == 16) {
            dtype = opencv_core.CV_16UC((int)(pix.d() / 16));
        } else if (pix.d() == 32) {
            dtype = opencv_core.CV_32FC((int)(pix.d() / 32));
        }
        mat2 = new org.bytedeco.opencv.opencv_core.Mat(height, width, dtype, (Pointer)pix.data());
        if (tempPix != null) {
            lept.pixDestroy((PIX)tempPix);
        }
        return mat2;
    }

    public INDArray asMatrix(String filename) throws IOException {
        return this.asMatrix(new File(filename));
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            INDArray iNDArray = this.asMatrix(bis);
            return iNDArray;
        }
    }

    @Override
    public INDArray asMatrix(InputStream is) throws IOException {
        INDArray a;
        org.bytedeco.opencv.opencv_core.Mat mat = this.streamToMat(is);
        if (this.multiPageMode != null) {
            a = this.asMatrix(mat.data(), mat.cols());
        } else {
            org.bytedeco.opencv.opencv_core.Mat image = opencv_imgcodecs.imdecode((org.bytedeco.opencv.opencv_core.Mat)mat, (int)6);
            if (image == null || image.empty()) {
                PIX pix = lept.pixReadMem((BytePointer)mat.data(), (long)mat.cols());
                if (pix == null) {
                    throw new IOException("Could not decode image from input stream");
                }
                image = NativeImageLoader.convert(pix);
                lept.pixDestroy((PIX)pix);
            }
            a = this.asMatrix(image);
            image.deallocate();
        }
        return a;
    }

    private org.bytedeco.opencv.opencv_core.Mat streamToMat(InputStream is) throws IOException {
        if (this.buffer == null) {
            this.buffer = IOUtils.toByteArray((InputStream)is);
            this.bufferMat = new org.bytedeco.opencv.opencv_core.Mat(this.buffer);
            return this.bufferMat;
        }
        int numReadTotal = is.read(this.buffer);
        if (numReadTotal < this.buffer.length) {
            this.bufferMat.data().put(this.buffer, 0, numReadTotal);
            this.bufferMat.cols(numReadTotal);
            return this.bufferMat;
        }
        int numReadCurrent = numReadTotal;
        while (numReadCurrent != -1) {
            byte[] oldBuffer = this.buffer;
            if (oldBuffer.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Cannot read more than Integer.MAX_VALUE bytes");
            }
            long increase = Math.max(this.buffer.length, 65536);
            int newBufferLength = (int)Math.min(Integer.MAX_VALUE, (long)this.buffer.length + increase);
            this.buffer = new byte[newBufferLength];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            numReadCurrent = is.read(this.buffer, oldBuffer.length, this.buffer.length - oldBuffer.length);
            if (numReadCurrent <= 0) continue;
            numReadTotal += numReadCurrent;
        }
        this.bufferMat = new org.bytedeco.opencv.opencv_core.Mat(this.buffer);
        return this.bufferMat;
    }

    public Image asImageMatrix(String filename) throws IOException {
        return this.asImageMatrix(filename);
    }

    @Override
    public Image asImageMatrix(File f) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            Image image = this.asImageMatrix(bis);
            return image;
        }
    }

    @Override
    public Image asImageMatrix(InputStream is) throws IOException {
        org.bytedeco.opencv.opencv_core.Mat mat = this.streamToMat(is);
        org.bytedeco.opencv.opencv_core.Mat image = opencv_imgcodecs.imdecode((org.bytedeco.opencv.opencv_core.Mat)mat, (int)6);
        if (image == null || image.empty()) {
            PIX pix = lept.pixReadMem((BytePointer)mat.data(), (long)mat.cols());
            if (pix == null) {
                throw new IOException("Could not decode image from input stream");
            }
            image = NativeImageLoader.convert(pix);
            lept.pixDestroy((PIX)pix);
        }
        INDArray a = this.asMatrix(image);
        Image i = new Image(a, image.channels(), image.rows(), image.cols());
        image.deallocate();
        return i;
    }

    public INDArray asMatrix(Object image) throws IOException {
        INDArray array = null;
        if (array == null) {
            try {
                array = new AndroidNativeImageLoader(this).asMatrix(image);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (array == null) {
            try {
                array = new Java2DNativeImageLoader(this).asMatrix(image);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return array;
    }

    protected void fillNDArray(org.bytedeco.opencv.opencv_core.Mat image, INDArray ret) {
        FloatIndexer floatidx;
        IntIndexer intidx;
        UShortIndexer ushortidx;
        long j;
        long i;
        long k;
        UByteIndexer ubyteidx;
        FloatIndexer retidx;
        long rows = image.rows();
        long cols = image.cols();
        long channels = image.channels();
        if (ret.length() != rows * cols * channels) {
            throw new ND4JIllegalStateException("INDArray provided to store image not equal to image: {channels: " + channels + ", rows: " + rows + ", columns: " + cols + "}");
        }
        Indexer idx = image.createIndexer(this.direct);
        Pointer pointer = ret.data().pointer();
        long[] stride = ret.stride();
        boolean done = false;
        PagedPointer pagedPointer = new PagedPointer(pointer, rows * cols * channels, ret.data().offset() * (long)Nd4j.sizeOfDataType((DataType)ret.data().dataType()));
        if (pointer instanceof FloatPointer) {
            retidx = FloatIndexer.create((FloatPointer)pagedPointer.asFloatPointer(), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[0], stride[1], stride[2]}, (boolean)this.direct);
            if (idx instanceof UByteIndexer) {
                ubyteidx = (UByteIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)ubyteidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof UShortIndexer) {
                ushortidx = (UShortIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)ushortidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof IntIndexer) {
                intidx = (IntIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (float)intidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof FloatIndexer) {
                floatidx = (FloatIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, floatidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            }
            retidx.release();
        } else if (pointer instanceof DoublePointer) {
            retidx = DoubleIndexer.create((DoublePointer)pagedPointer.asDoublePointer(), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[0], stride[1], stride[2]}, (boolean)this.direct);
            if (idx instanceof UByteIndexer) {
                ubyteidx = (UByteIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)ubyteidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof UShortIndexer) {
                ushortidx = (UShortIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)ushortidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof IntIndexer) {
                intidx = (IntIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)intidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            } else if (idx instanceof FloatIndexer) {
                floatidx = (FloatIndexer)idx;
                for (k = 0L; k < channels; ++k) {
                    for (i = 0L; i < rows; ++i) {
                        for (j = 0L; j < cols; ++j) {
                            retidx.put(k, i, j, (double)floatidx.get(i, j, k));
                        }
                    }
                }
                done = true;
            }
            retidx.release();
        }
        if (!done) {
            for (long k2 = 0L; k2 < channels; ++k2) {
                for (long i2 = 0L; i2 < rows; ++i2) {
                    for (long j2 = 0L; j2 < cols; ++j2) {
                        if (ret.rank() == 3) {
                            ret.putScalar(k2, i2, j2, idx.getDouble(new long[]{i2, j2, k2}));
                            continue;
                        }
                        if (ret.rank() == 4) {
                            ret.putScalar(1L, k2, i2, j2, idx.getDouble(new long[]{i2, j2, k2}));
                            continue;
                        }
                        if (ret.rank() == 2) {
                            ret.putScalar(i2, j2, idx.getDouble(new long[]{i2, j2}));
                            continue;
                        }
                        throw new ND4JIllegalStateException("NativeImageLoader expects 2D, 3D or 4D output array, but " + ret.rank() + "D array was given");
                    }
                }
            }
        }
        idx.release();
        image.data();
        Nd4j.getAffinityManager().tagLocation(ret, AffinityManager.Location.HOST);
    }

    public void asMatrixView(InputStream is, INDArray view) throws IOException {
        org.bytedeco.opencv.opencv_core.Mat mat = this.streamToMat(is);
        org.bytedeco.opencv.opencv_core.Mat image = opencv_imgcodecs.imdecode((org.bytedeco.opencv.opencv_core.Mat)mat, (int)6);
        if (image == null || image.empty()) {
            PIX pix = lept.pixReadMem((BytePointer)mat.data(), (long)mat.cols());
            if (pix == null) {
                throw new IOException("Could not decode image from input stream");
            }
            image = NativeImageLoader.convert(pix);
            lept.pixDestroy((PIX)pix);
        }
        if (image == null) {
            throw new RuntimeException();
        }
        this.asMatrixView(image, view);
        image.deallocate();
    }

    public void asMatrixView(String filename, INDArray view) throws IOException {
        this.asMatrixView(new File(filename), view);
    }

    public void asMatrixView(File f, INDArray view) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            this.asMatrixView(bis, view);
        }
    }

    public void asMatrixView(org.bytedeco.opencv.opencv_core.Mat image, INDArray view) throws IOException {
        this.transformImage(image, view);
    }

    public void asMatrixView(Mat image, INDArray view) throws IOException {
        this.transformImage(image, view);
    }

    public INDArray asMatrix(Frame image) throws IOException {
        return this.asMatrix(this.converter.convert(image));
    }

    public INDArray asMatrix(Mat image) throws IOException {
        INDArray ret = this.transformImage(image, null);
        return ret.reshape(ArrayUtil.combine((long[][])new long[][]{{1L}, ret.shape()}));
    }

    public INDArray asMatrix(org.bytedeco.opencv.opencv_core.Mat image) throws IOException {
        INDArray ret = this.transformImage(image, null);
        return ret.reshape(ArrayUtil.combine((long[][])new long[][]{{1L}, ret.shape()}));
    }

    protected INDArray transformImage(Mat image, INDArray ret) throws IOException {
        Frame f = this.converter.convert(image);
        return this.transformImage(this.converter.convert(f), ret);
    }

    protected INDArray transformImage(org.bytedeco.opencv.opencv_core.Mat image, INDArray ret) throws IOException {
        if (this.imageTransform != null && this.converter != null) {
            ImageWritable writable = new ImageWritable(this.converter.convert(image));
            writable = this.imageTransform.transform(writable);
            image = this.converter.convert(writable.getFrame());
        }
        org.bytedeco.opencv.opencv_core.Mat image2 = null;
        org.bytedeco.opencv.opencv_core.Mat image3 = null;
        org.bytedeco.opencv.opencv_core.Mat image4 = null;
        if (this.channels > 0L && (long)image.channels() != this.channels) {
            int code = -1;
            block0 : switch (image.channels()) {
                case 1: {
                    switch ((int)this.channels) {
                        case 3: {
                            code = 8;
                            break;
                        }
                        case 4: {
                            code = 9;
                        }
                    }
                    break;
                }
                case 3: {
                    switch ((int)this.channels) {
                        case 1: {
                            code = 6;
                            break;
                        }
                        case 4: {
                            code = 2;
                        }
                    }
                    break;
                }
                case 4: {
                    switch ((int)this.channels) {
                        case 1: {
                            code = 11;
                            break block0;
                        }
                        case 3: {
                            code = 3;
                        }
                    }
                }
            }
            if (code < 0) {
                throw new IOException("Cannot convert from " + image.channels() + " to " + this.channels + " channels.");
            }
            image2 = new org.bytedeco.opencv.opencv_core.Mat();
            opencv_imgproc.cvtColor((org.bytedeco.opencv.opencv_core.Mat)image, (org.bytedeco.opencv.opencv_core.Mat)image2, (int)code);
            image = image2;
        }
        if (this.centerCropIfNeeded) {
            image3 = this.centerCropIfNeeded(image);
            if (image3 != image) {
                image = image3;
            } else {
                image3 = null;
            }
        }
        if ((image4 = this.scalingIfNeed(image)) != image) {
            image = image4;
        } else {
            image4 = null;
        }
        if (ret == null) {
            int rows = image.rows();
            int cols = image.cols();
            int channels = image.channels();
            ret = Nd4j.create((int[])new int[]{channels, rows, cols});
        }
        this.fillNDArray(image, ret);
        image.data();
        if (image2 != null) {
            image2.deallocate();
        }
        if (image3 != null) {
            image3.deallocate();
        }
        if (image4 != null) {
            image4.deallocate();
        }
        return ret;
    }

    protected org.bytedeco.opencv.opencv_core.Mat centerCropIfNeeded(org.bytedeco.opencv.opencv_core.Mat img) {
        int x = 0;
        int y = 0;
        int height = img.rows();
        int width = img.cols();
        int diff = Math.abs(width - height) / 2;
        if (width > height) {
            x = diff;
            width -= diff;
        } else if (height > width) {
            y = diff;
            height -= diff;
        }
        return img.apply(new Rect(x, y, width, height));
    }

    protected org.bytedeco.opencv.opencv_core.Mat scalingIfNeed(org.bytedeco.opencv.opencv_core.Mat image) {
        return this.scalingIfNeed(image, this.height, this.width);
    }

    protected org.bytedeco.opencv.opencv_core.Mat scalingIfNeed(org.bytedeco.opencv.opencv_core.Mat image, long dstHeight, long dstWidth) {
        org.bytedeco.opencv.opencv_core.Mat scaled = image;
        if (dstHeight > 0L && dstWidth > 0L && ((long)image.rows() != dstHeight || (long)image.cols() != dstWidth)) {
            scaled = new org.bytedeco.opencv.opencv_core.Mat();
            opencv_imgproc.resize((org.bytedeco.opencv.opencv_core.Mat)image, (org.bytedeco.opencv.opencv_core.Mat)scaled, (Size)new Size((int)Math.min(dstWidth, Integer.MAX_VALUE), (int)Math.min(dstHeight, Integer.MAX_VALUE)));
        }
        return scaled;
    }

    public ImageWritable asWritable(String filename) throws IOException {
        return this.asWritable(new File(filename));
    }

    public ImageWritable asWritable(File f) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            ImageWritable writable;
            org.bytedeco.opencv.opencv_core.Mat mat = this.streamToMat(bis);
            org.bytedeco.opencv.opencv_core.Mat image = opencv_imgcodecs.imdecode((org.bytedeco.opencv.opencv_core.Mat)mat, (int)6);
            if (image == null || image.empty()) {
                PIX pix = lept.pixReadMem((BytePointer)mat.data(), (long)mat.cols());
                if (pix == null) {
                    throw new IOException("Could not decode image from input stream");
                }
                image = NativeImageLoader.convert(pix);
                lept.pixDestroy((PIX)pix);
            }
            ImageWritable imageWritable = writable = new ImageWritable(this.converter.convert(image));
            return imageWritable;
        }
    }

    public INDArray asMatrix(ImageWritable writable) throws IOException {
        org.bytedeco.opencv.opencv_core.Mat image = this.converter.convert(writable.getFrame());
        return this.asMatrix(image);
    }

    public Frame asFrame(INDArray array) {
        return this.converter.convert(this.asMat(array));
    }

    public Frame asFrame(INDArray array, int dataType) {
        return this.converter.convert(this.asMat(array, OpenCVFrameConverter.getMatDepth((int)dataType)));
    }

    public org.bytedeco.opencv.opencv_core.Mat asMat(INDArray array) {
        return this.asMat(array, -1);
    }

    public org.bytedeco.opencv.opencv_core.Mat asMat(INDArray array, int dataType) {
        long j;
        long i;
        long k;
        FloatIndexer idx;
        FloatIndexer ptridx;
        if (array.rank() > 4 || array.rank() > 3 && array.size(0) != 1L) {
            throw new UnsupportedOperationException("Only rank 3 (or rank 4 with size(0) == 1) arrays supported");
        }
        int rank = array.rank();
        long[] stride = array.stride();
        long offset = array.data().offset();
        Pointer pointer = array.data().pointer().position(offset);
        long rows = array.size(rank == 3 ? 1 : 2);
        long cols = array.size(rank == 3 ? 2 : 3);
        long channels = array.size(rank == 3 ? 0 : 1);
        boolean done = false;
        if (dataType < 0) {
            dataType = pointer instanceof DoublePointer ? 6 : 5;
        }
        org.bytedeco.opencv.opencv_core.Mat mat = new org.bytedeco.opencv.opencv_core.Mat((int)Math.min(rows, Integer.MAX_VALUE), (int)Math.min(cols, Integer.MAX_VALUE), opencv_core.CV_MAKETYPE((int)dataType, (int)((int)Math.min(channels, Integer.MAX_VALUE))));
        Indexer matidx = mat.createIndexer(this.direct);
        Nd4j.getAffinityManager().ensureLocation(array, AffinityManager.Location.HOST);
        if (pointer instanceof FloatPointer && dataType == 5) {
            ptridx = FloatIndexer.create((FloatPointer)((FloatPointer)pointer), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[rank == 3 ? 0 : 1], stride[rank == 3 ? 1 : 2], stride[rank == 3 ? 2 : 3]}, (boolean)this.direct);
            idx = (FloatIndexer)matidx;
            for (k = 0L; k < channels; ++k) {
                for (i = 0L; i < rows; ++i) {
                    for (j = 0L; j < cols; ++j) {
                        idx.put(i, j, k, ptridx.get(k, i, j));
                    }
                }
            }
            done = true;
            ptridx.release();
        } else if (pointer instanceof DoublePointer && dataType == 6) {
            ptridx = DoubleIndexer.create((DoublePointer)((DoublePointer)pointer), (long[])new long[]{channels, rows, cols}, (long[])new long[]{stride[rank == 3 ? 0 : 1], stride[rank == 3 ? 1 : 2], stride[rank == 3 ? 2 : 3]}, (boolean)this.direct);
            idx = (DoubleIndexer)matidx;
            for (k = 0L; k < channels; ++k) {
                for (i = 0L; i < rows; ++i) {
                    for (j = 0L; j < cols; ++j) {
                        idx.put(i, j, k, ptridx.get(k, i, j));
                    }
                }
            }
            done = true;
            ptridx.release();
        }
        if (!done) {
            for (long k2 = 0L; k2 < channels; ++k2) {
                for (long i2 = 0L; i2 < rows; ++i2) {
                    for (long j2 = 0L; j2 < cols; ++j2) {
                        if (rank == 3) {
                            matidx.putDouble(new long[]{i2, j2, k2}, array.getDouble(new long[]{k2, i2, j2}));
                            continue;
                        }
                        matidx.putDouble(new long[]{i2, j2, k2}, array.getDouble(new long[]{0L, k2, i2, j2}));
                    }
                }
            }
        }
        matidx.release();
        return mat;
    }

    private INDArray asMatrix(BytePointer bytes, long length) throws IOException {
        INDArray data;
        PIXA pixa = lept.pixaReadMemMultipageTiff((BytePointer)bytes, (long)length);
        INDArrayIndex[] index = null;
        switch (this.multiPageMode) {
            case MINIBATCH: {
                data = Nd4j.create((int[])new int[]{pixa.n(), 1, 1, pixa.pix(0).h(), pixa.pix(0).w()});
                break;
            }
            case FIRST: {
                INDArray data2 = Nd4j.create((int[])new int[]{1, 1, 1, pixa.pix(0).h(), pixa.pix(0).w()});
                PIX pix = pixa.pix(0);
                INDArray currentD = this.asMatrix(NativeImageLoader.convert(pix));
                lept.pixDestroy((PIX)pix);
                index = new INDArrayIndex[]{NDArrayIndex.point((long)0L), NDArrayIndex.point((long)0L), NDArrayIndex.point((long)0L), NDArrayIndex.all(), NDArrayIndex.all()};
                data2.put(index, currentD.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}));
                return data2;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported MultiPageMode: " + (Object)((Object)this.multiPageMode));
            }
        }
        for (int i = 0; i < pixa.n(); ++i) {
            PIX pix = pixa.pix(i);
            INDArray currentD = this.asMatrix(NativeImageLoader.convert(pix));
            lept.pixDestroy((PIX)pix);
            switch (this.multiPageMode) {
                case MINIBATCH: {
                    index = new INDArrayIndex[]{NDArrayIndex.point((long)i), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()};
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported MultiPageMode: " + (Object)((Object)this.multiPageMode));
                }
            }
            data.put(index, currentD.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}));
        }
        return data;
    }
}

