/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"borderValue"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BoxImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int width;
    private int height;
    private int x;
    private int y;
    opencv_core.Scalar borderValue = opencv_core.Scalar.ZERO;

    public BoxImageTransform(@JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        this(null, width, height);
    }

    public BoxImageTransform(Random random, int width, int height) {
        super(random);
        this.width = width;
        this.height = height;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat box = new opencv_core.Mat(this.height, this.width, mat.type());
        box.put(this.borderValue);
        this.x = (mat.cols() - this.width) / 2;
        this.y = (mat.rows() - this.height) / 2;
        int w = Math.min(mat.cols(), this.width);
        int h = Math.min(mat.rows(), this.height);
        opencv_core.Rect matRect = new opencv_core.Rect(this.x, this.y, w, h);
        opencv_core.Rect boxRect = new opencv_core.Rect(this.x, this.y, w, h);
        if (this.x <= 0) {
            matRect.x(0);
            boxRect.x(-this.x);
        } else {
            matRect.x(this.x);
            boxRect.x(0);
        }
        if (this.y <= 0) {
            matRect.y(0);
            boxRect.y(-this.y);
        } else {
            matRect.y(this.y);
            boxRect.y(0);
        }
        mat.apply(matRect).copyTo(box.apply(boxRect));
        return new ImageWritable(this.converter.convert((Object)box));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }

    public opencv_core.Scalar borderValue() {
        return this.borderValue;
    }

    public BoxImageTransform borderValue(opencv_core.Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

