/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.FrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"converter", "currentImage"})
public abstract class BaseImageTransform<F>
implements ImageTransform {
    protected Random random;
    protected FrameConverter<F> converter;
    protected ImageWritable currentImage;

    protected BaseImageTransform(Random random) {
        this.random = random;
    }

    @Override
    public final ImageWritable transform(ImageWritable image) {
        return this.transform(image, this.random);
    }

    @Override
    public final ImageWritable transform(ImageWritable image, Random random) {
        this.currentImage = this.doTransform(image, random);
        return this.currentImage;
    }

    protected abstract ImageWritable doTransform(ImageWritable var1, Random var2);

    @Override
    public float[] query(float ... coordinates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageWritable getCurrentImage() {
        return this.currentImage;
    }

    public BaseImageTransform() {
    }
}

