/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.recordreader;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.datavec.common.RecordConverter;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.loader.ImageLoader;
import org.datavec.image.loader.NativeImageLoader;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseImageRecordReader
extends BaseRecordReader {
    protected Iterator<File> iter;
    protected Configuration conf;
    protected File currentFile;
    protected PathLabelGenerator labelGenerator = null;
    protected List<String> labels = new ArrayList<String>();
    protected boolean appendLabel = false;
    protected List<Writable> record;
    protected boolean hitImage = false;
    protected int height = 28;
    protected int width = 28;
    protected int channels = 1;
    protected boolean cropImage = false;
    protected ImageTransform imageTransform;
    protected BaseImageLoader imageLoader;
    protected InputSplit inputSplit;
    protected Map<String, String> fileNameMap = new LinkedHashMap<String, String>();
    protected String pattern;
    protected int patternPosition = 0;
    protected double normalizeValue = 0.0;
    public static final String HEIGHT = NAME_SPACE + ".height";
    public static final String WIDTH = NAME_SPACE + ".width";
    public static final String CHANNELS = NAME_SPACE + ".channels";
    public static final String CROP_IMAGE = NAME_SPACE + ".cropimage";
    public static final String IMAGE_LOADER = NAME_SPACE + ".imageloader";

    public BaseImageRecordReader() {
    }

    public BaseImageRecordReader(int height, int width, int channels, PathLabelGenerator labelGenerator) {
        this(height, width, channels, labelGenerator, null, 0.0);
    }

    public BaseImageRecordReader(int height, int width, int channels, PathLabelGenerator labelGenerator, ImageTransform imageTransform, double normalizeValue) {
        this.height = height;
        this.width = width;
        this.channels = channels;
        this.labelGenerator = labelGenerator;
        this.imageTransform = imageTransform;
        this.appendLabel = labelGenerator != null;
        this.normalizeValue = normalizeValue;
    }

    protected boolean containsFormat(String format) {
        for (String format2 : this.imageLoader.getAllowedFormats()) {
            if (!format.endsWith("." + format2)) continue;
            return true;
        }
        return false;
    }

    public void initialize(InputSplit split) throws IOException {
        if (this.imageLoader == null) {
            this.imageLoader = new NativeImageLoader(this.height, this.width, this.channels, this.imageTransform, this.normalizeValue);
        }
        this.inputSplit = split;
        URI[] locations = split.locations();
        if (locations != null && locations.length >= 1) {
            Collection<Object> allFiles;
            if (locations.length > 1 || this.containsFormat(locations[0].getPath())) {
                allFiles = new ArrayList();
                for (URI location : locations) {
                    File imgFile = new File(location);
                    if (!imgFile.isDirectory() && this.containsFormat(imgFile.getAbsolutePath())) {
                        allFiles.add(imgFile);
                    }
                    if (!this.appendLabel) continue;
                    File parentDir = imgFile.getParentFile();
                    String name = parentDir.getName();
                    if (this.labelGenerator != null) {
                        name = this.labelGenerator.getLabelForPath(location).toString();
                    }
                    if (!this.labels.contains(name)) {
                        this.labels.add(name);
                    }
                    if (this.pattern == null) continue;
                    String label = name.split(this.pattern)[this.patternPosition];
                    this.fileNameMap.put(imgFile.toString(), label);
                }
            } else {
                File curr = new File(locations[0]);
                if (!curr.exists()) {
                    throw new IllegalArgumentException("Path " + curr.getAbsolutePath() + " does not exist!");
                }
                allFiles = curr.isDirectory() ? FileUtils.listFiles((File)curr, null, (boolean)true) : Collections.singletonList(curr);
            }
            this.iter = allFiles.iterator();
        }
        if (split instanceof FileSplit) {
            FileSplit split1 = (FileSplit)split;
            this.labels.remove(split1.getRootDir());
        }
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.appendLabel = conf.getBoolean(APPEND_LABEL, false);
        this.labels = new ArrayList<String>(conf.getStringCollection(LABELS));
        this.height = conf.getInt(HEIGHT, this.height);
        this.width = conf.getInt(WIDTH, this.width);
        this.channels = conf.getInt(CHANNELS, this.channels);
        this.cropImage = conf.getBoolean(CROP_IMAGE, this.cropImage);
        this.imageLoader = "imageio".equals(conf.get(IMAGE_LOADER)) ? new ImageLoader(this.height, this.width, this.channels, this.cropImage) : new NativeImageLoader(this.height, this.width, this.channels, this.imageTransform, this.normalizeValue);
        this.conf = conf;
        this.initialize(split);
    }

    public void initialize(InputSplit split, ImageTransform imageTransform) throws IOException {
        this.imageLoader = null;
        this.imageTransform = imageTransform;
        this.initialize(split);
    }

    public void initialize(Configuration conf, InputSplit split, ImageTransform imageTransform) throws IOException, InterruptedException {
        this.imageLoader = null;
        this.imageTransform = imageTransform;
        this.initialize(conf, split);
    }

    public List<Writable> next() {
        if (this.iter != null) {
            File image;
            List<Object> ret = new ArrayList<Writable>();
            this.currentFile = image = this.iter.next();
            if (image.isDirectory()) {
                return this.next();
            }
            try {
                this.invokeListeners(image);
                INDArray row = this.imageLoader.asMatrix(image);
                ret = RecordConverter.toRecord((INDArray)row);
                if (this.appendLabel) {
                    ret.add((Writable)new IntWritable(this.labels.indexOf(this.getLabel(image.getPath()))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
        if (this.record != null) {
            this.hitImage = true;
            this.invokeListeners(this.record);
            return this.record;
        }
        throw new IllegalStateException("No more elements");
    }

    public boolean hasNext() {
        if (this.iter != null) {
            boolean hasNext = this.iter.hasNext();
            if (!hasNext && this.imageTransform != null) {
                this.imageTransform.transform(null);
            }
            return hasNext;
        }
        if (this.record != null) {
            if (this.hitImage && this.imageTransform != null) {
                this.imageTransform.transform(null);
            }
            return !this.hitImage;
        }
        if (this.imageTransform != null) {
            this.imageTransform.transform(null);
        }
        throw new IllegalStateException("Indeterminant state: record must not be null, or a file iterator must exist");
    }

    public void close() throws IOException {
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getLabel(String path) {
        if (this.labelGenerator != null) {
            return this.labelGenerator.getLabelForPath(path).toString();
        }
        if (this.fileNameMap != null && this.fileNameMap.containsKey(path)) {
            return this.fileNameMap.get(path);
        }
        return new File(path).getParentFile().getName();
    }

    protected void accumulateLabel(String path) {
        String name = this.getLabel(path);
        if (!this.labels.contains(name)) {
            this.labels.add(name);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.initialize(this.inputSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during LineRecordReader reset", e);
        }
    }

    public int numLabels() {
        return this.labels.size();
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        this.invokeListeners(uri);
        if (this.imageLoader == null) {
            this.imageLoader = new NativeImageLoader(this.height, this.width, this.channels, this.imageTransform);
        }
        INDArray row = this.imageLoader.asMatrix(dataInputStream);
        List ret = RecordConverter.toRecord((INDArray)row);
        if (this.appendLabel) {
            ret.add(new IntWritable(this.labels.indexOf(this.getLabel(uri.getPath()))));
        }
        return ret;
    }
}

