/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;

public class WritableFactory {
    private static WritableFactory INSTANCE = new WritableFactory();
    private Map<Short, Class<? extends Writable>> map = new ConcurrentHashMap<Short, Class<? extends Writable>>();
    private Map<Short, Constructor<? extends Writable>> constructorMap = new ConcurrentHashMap<Short, Constructor<? extends Writable>>();

    private WritableFactory() {
        for (WritableType wt : WritableType.values()) {
            if (!wt.isCoreWritable()) continue;
            this.registerWritableType((short)wt.ordinal(), wt.getWritableClass());
        }
    }

    public static WritableFactory getInstance() {
        return INSTANCE;
    }

    public void registerWritableType(short writableTypeKey, @NonNull Class<? extends Writable> writableClass) {
        Constructor<? extends Writable> c;
        if (writableClass == null) {
            throw new NullPointerException("writableClass is marked @NonNull but is null");
        }
        if (this.map.containsKey(writableTypeKey)) {
            throw new UnsupportedOperationException("Key " + writableTypeKey + " is already registered to type " + this.map.get(writableTypeKey) + " and cannot be registered to " + writableClass);
        }
        try {
            c = writableClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot find no-arg constructor for class " + writableClass);
        }
        this.map.put(writableTypeKey, writableClass);
        this.constructorMap.put(writableTypeKey, c);
    }

    public Writable newWritable(short writableTypeKey) {
        Constructor<? extends Writable> c = this.constructorMap.get(writableTypeKey);
        if (c == null) {
            throw new IllegalStateException("Unknown writable key: " + writableTypeKey);
        }
        try {
            return c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new Writable instance");
        }
    }

    public void writeWithType(Writable w, DataOutput dataOutput) throws IOException {
        w.writeType(dataOutput);
        w.write(dataOutput);
    }

    public Writable readWithType(DataInput dataInput) throws IOException {
        Writable w = this.newWritable(dataInput.readShort());
        w.readFields(dataInput);
        return w;
    }
}

