/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.DataAction;
import org.datavec.api.transform.Distance;
import org.datavec.api.transform.MathFunction;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.analysis.DataAnalysis;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.filter.ConditionFilter;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.ndarray.NDArrayColumnsMathOpTransform;
import org.datavec.api.transform.ndarray.NDArrayDistanceTransform;
import org.datavec.api.transform.ndarray.NDArrayMathFunctionTransform;
import org.datavec.api.transform.ndarray.NDArrayScalarOpTransform;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.reduce.IAssociativeReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.ConvertFromSequence;
import org.datavec.api.transform.sequence.ConvertToSequence;
import org.datavec.api.transform.sequence.ReduceSequenceTransform;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.transform.sequence.trim.SequenceTrimTransform;
import org.datavec.api.transform.sequence.window.ReduceSequenceByWindowTransform;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.transform.serde.JsonMappers;
import org.datavec.api.transform.transform.categorical.CategoricalToIntegerTransform;
import org.datavec.api.transform.transform.categorical.CategoricalToOneHotTransform;
import org.datavec.api.transform.transform.categorical.FirstDigitTransform;
import org.datavec.api.transform.transform.categorical.IntegerToCategoricalTransform;
import org.datavec.api.transform.transform.categorical.StringToCategoricalTransform;
import org.datavec.api.transform.transform.column.AddConstantColumnTransform;
import org.datavec.api.transform.transform.column.DuplicateColumnsTransform;
import org.datavec.api.transform.transform.column.RemoveAllColumnsExceptForTransform;
import org.datavec.api.transform.transform.column.RemoveColumnsTransform;
import org.datavec.api.transform.transform.column.RenameColumnsTransform;
import org.datavec.api.transform.transform.column.ReorderColumnsTransform;
import org.datavec.api.transform.transform.condition.ConditionalCopyValueTransform;
import org.datavec.api.transform.transform.condition.ConditionalReplaceValueTransform;
import org.datavec.api.transform.transform.condition.ConditionalReplaceValueTransformWithDefault;
import org.datavec.api.transform.transform.doubletransform.ConvertToDouble;
import org.datavec.api.transform.transform.doubletransform.DoubleColumnsMathOpTransform;
import org.datavec.api.transform.transform.doubletransform.DoubleMathFunctionTransform;
import org.datavec.api.transform.transform.doubletransform.DoubleMathOpTransform;
import org.datavec.api.transform.transform.doubletransform.Log2Normalizer;
import org.datavec.api.transform.transform.doubletransform.MinMaxNormalizer;
import org.datavec.api.transform.transform.doubletransform.StandardizeNormalizer;
import org.datavec.api.transform.transform.doubletransform.SubtractMeanNormalizer;
import org.datavec.api.transform.transform.floattransform.FloatColumnsMathOpTransform;
import org.datavec.api.transform.transform.floattransform.FloatMathFunctionTransform;
import org.datavec.api.transform.transform.floattransform.FloatMathOpTransform;
import org.datavec.api.transform.transform.integer.ConvertToInteger;
import org.datavec.api.transform.transform.integer.IntegerColumnsMathOpTransform;
import org.datavec.api.transform.transform.integer.IntegerMathOpTransform;
import org.datavec.api.transform.transform.integer.IntegerToOneHotTransform;
import org.datavec.api.transform.transform.longtransform.LongColumnsMathOpTransform;
import org.datavec.api.transform.transform.longtransform.LongMathOpTransform;
import org.datavec.api.transform.transform.normalize.Normalize;
import org.datavec.api.transform.transform.sequence.SequenceMovingWindowReduceTransform;
import org.datavec.api.transform.transform.sequence.SequenceOffsetTransform;
import org.datavec.api.transform.transform.string.AppendStringColumnTransform;
import org.datavec.api.transform.transform.string.ConvertToString;
import org.datavec.api.transform.transform.string.RemoveWhiteSpaceTransform;
import org.datavec.api.transform.transform.string.ReplaceStringTransform;
import org.datavec.api.transform.transform.string.StringMapTransform;
import org.datavec.api.transform.transform.time.StringToTimeTransform;
import org.datavec.api.transform.transform.time.TimeMathOpTransform;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.comparator.WritableComparator;
import org.joda.time.DateTimeZone;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformProcess
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransformProcess.class);
    private final Schema initialSchema;
    private List<DataAction> actionList;

    public TransformProcess(@JsonProperty(value="initialSchema") Schema initialSchema, @JsonProperty(value="actionList") List<DataAction> actionList) {
        this.initialSchema = initialSchema;
        this.actionList = actionList;
        Schema currInputSchema = initialSchema;
        for (DataAction d : actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                t.setInputSchema(currInputSchema);
                currInputSchema = t.transform(currInputSchema);
                continue;
            }
            if (d.getFilter() != null) {
                d.getFilter().setInputSchema(currInputSchema);
                continue;
            }
            if (d.getConvertToSequence() != null) {
                if (currInputSchema instanceof SequenceSchema) {
                    throw new RuntimeException("Cannot convert to sequence: schema is already a sequence schema: " + currInputSchema);
                }
                ConvertToSequence cts = d.getConvertToSequence();
                cts.setInputSchema(currInputSchema);
                currInputSchema = cts.transform(currInputSchema);
                continue;
            }
            if (d.getConvertFromSequence() != null) {
                ConvertFromSequence cfs = d.getConvertFromSequence();
                if (!(currInputSchema instanceof SequenceSchema)) {
                    throw new RuntimeException("Cannot convert from sequence: schema is not a sequence schema: " + currInputSchema);
                }
                cfs.setInputSchema((SequenceSchema)currInputSchema);
                currInputSchema = cfs.transform((SequenceSchema)currInputSchema);
                continue;
            }
            if (d.getSequenceSplit() != null) {
                d.getSequenceSplit().setInputSchema(currInputSchema);
                continue;
            }
            if (d.getReducer() != null) {
                IAssociativeReducer reducer = d.getReducer();
                reducer.setInputSchema(currInputSchema);
                currInputSchema = reducer.transform(currInputSchema);
                continue;
            }
            if (d.getCalculateSortedRank() != null) {
                CalculateSortedRank csr = d.getCalculateSortedRank();
                csr.setInputSchema(currInputSchema);
                currInputSchema = csr.transform(currInputSchema);
                continue;
            }
            throw new RuntimeException("Unknown action: " + d);
        }
    }

    private TransformProcess(Builder builder) {
        this(builder.initialSchema, builder.actionList);
    }

    public List<DataAction> getActionList() {
        return this.actionList;
    }

    public Schema getFinalSchema() {
        return this.getSchemaAfterStep(this.actionList.size());
    }

    public Schema getSchemaAfterStep(int step) {
        Schema currInputSchema = this.initialSchema;
        int i = 0;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currInputSchema = t.transform(currInputSchema);
            } else {
                if (d.getFilter() != null) {
                    ++i;
                    continue;
                }
                if (d.getConvertToSequence() != null) {
                    if (currInputSchema instanceof SequenceSchema) {
                        throw new RuntimeException("Cannot convert to sequence: schema is already a sequence schema: " + currInputSchema);
                    }
                    ConvertToSequence cts = d.getConvertToSequence();
                    currInputSchema = cts.transform(currInputSchema);
                } else if (d.getConvertFromSequence() != null) {
                    ConvertFromSequence cfs = d.getConvertFromSequence();
                    if (!(currInputSchema instanceof SequenceSchema)) {
                        throw new RuntimeException("Cannot convert from sequence: schema is not a sequence schema: " + currInputSchema);
                    }
                    currInputSchema = cfs.transform((SequenceSchema)currInputSchema);
                } else {
                    if (d.getSequenceSplit() != null) continue;
                    if (d.getReducer() != null) {
                        IAssociativeReducer reducer = d.getReducer();
                        currInputSchema = reducer.transform(currInputSchema);
                    } else if (d.getCalculateSortedRank() != null) {
                        CalculateSortedRank csr = d.getCalculateSortedRank();
                        currInputSchema = csr.transform(currInputSchema);
                    } else {
                        throw new RuntimeException("Unknown action: " + d);
                    }
                }
            }
            if (i++ != step) continue;
            return currInputSchema;
        }
        return currInputSchema;
    }

    public List<Writable> execute(List<Writable> input) {
        List<Writable> currValues = input;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currValues = t.map(currValues);
                continue;
            }
            if (d.getFilter() != null) {
                Filter f = d.getFilter();
                if (!f.removeExample(currValues)) continue;
                return null;
            }
            if (d.getConvertToSequence() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a ConvertToSequence operation");
            }
            if (d.getConvertFromSequence() != null) {
                throw new RuntimeException("Unexpected operation: TransformProcess contains a ConvertFromSequence operation");
            }
            if (d.getSequenceSplit() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a SequenceSplit operation");
            }
            throw new RuntimeException("Unknown action: " + d);
        }
        return currValues;
    }

    public List<List<Writable>> executeSequenceToSequence(List<List<Writable>> input) {
        List<List<Writable>> currValues = input;
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                currValues = t.mapSequence(currValues);
                continue;
            }
            if (d.getFilter() != null) {
                if (!d.getFilter().removeSequence(currValues)) continue;
                return null;
            }
            if (d.getConvertToSequence() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a ConvertToSequence operation");
            }
            if (d.getConvertFromSequence() != null) {
                throw new RuntimeException("Unexpected operation: TransformProcess contains a ConvertFromSequence operation");
            }
            if (d.getSequenceSplit() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a SequenceSplit operation");
            }
            throw new RuntimeException("Unknown or not supported action: " + d);
        }
        return currValues;
    }

    public List<List<Writable>> executeSequence(List<List<Writable>> inputSequence) {
        return this.executeSequenceToSequence(inputSequence);
    }

    public List<List<List<Writable>>> executeToSequenceBatch(List<List<Writable>> inputExample) {
        ArrayList<List<List<Writable>>> ret = new ArrayList<List<List<Writable>>>();
        for (List<Writable> record : inputExample) {
            ret.add((List<List<Writable>>)this.execute(record, null).getRight());
        }
        return ret;
    }

    public List<List<Writable>> executeToSequence(List<Writable> inputExample) {
        return (List)this.execute(inputExample, null).getRight();
    }

    public List<Writable> executeSequenceToSingle(List<List<Writable>> inputSequence) {
        return (List)this.execute(null, inputSequence).getLeft();
    }

    private Pair<List<Writable>, List<List<Writable>>> execute(List<Writable> currEx, List<List<Writable>> currSeq) {
        for (DataAction d : this.actionList) {
            if (d.getTransform() != null) {
                Transform t = d.getTransform();
                if (currEx != null) {
                    currEx = t.map(currEx);
                    currSeq = null;
                    continue;
                }
                currEx = null;
                currSeq = t.mapSequence(currSeq);
                continue;
            }
            if (d.getFilter() != null) {
                if ((currEx == null || !d.getFilter().removeExample(currEx)) && !d.getFilter().removeSequence(currEx)) continue;
                return new Pair(null, null);
            }
            if (d.getConvertToSequence() != null) {
                if (d.getConvertToSequence().isSingleStepSequencesMode()) {
                    if (currSeq != null) {
                        throw new RuntimeException("Cannot execute ConvertToSequence op: current records are already a sequence");
                    }
                    currSeq = Collections.singletonList(currEx);
                    currEx = null;
                    continue;
                }
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a ConvertToSequence operation, with singleStepSequnceeMode == false. Only  ConvertToSequence operations with singleStepSequnceeMode == true can be executed individually as other types require a groupBy operation (which cannot be executed when only a sinlge record) is provided as input");
            }
            if (d.getConvertFromSequence() != null) {
                throw new RuntimeException("Unexpected operation: TransformProcess contains a ConvertFromSequence operation. This would produce multiple output records, which cannot be executed using this method");
            }
            if (d.getSequenceSplit() != null) {
                throw new RuntimeException("Cannot execute examples individually: TransformProcess contains a SequenceSplit operation. This would produce multiple output records, which cannot be executed using this method");
            }
            throw new RuntimeException("Unknown or not supported action: " + d);
        }
        return new Pair(currEx, currSeq);
    }

    public String toJson() {
        try {
            return JsonMappers.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return JsonMappers.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransformProcess fromJson(String json) {
        try {
            return (TransformProcess)JsonMappers.getMapper().readValue(json, TransformProcess.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransformProcess fromYaml(String yaml) {
        try {
            return (TransformProcess)JsonMappers.getMapper().readValue(yaml, TransformProcess.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> inferCategories(RecordReader recordReader, int columnIndex) {
        HashSet<String> categories = new HashSet<String>();
        while (recordReader.hasNext()) {
            List<Writable> next = recordReader.next();
            categories.add(next.get(columnIndex).toString());
        }
        ArrayList<String> ret = new ArrayList<String>(categories);
        Collections.sort(ret);
        return ret;
    }

    public static Map<Integer, List<String>> inferCategories(RecordReader recordReader, int[] columnIndices) {
        int i;
        if (columnIndices == null || columnIndices.length < 1) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<String>> categoryMap = new HashMap<Integer, List<String>>();
        HashMap categories = new HashMap();
        for (i = 0; i < columnIndices.length; ++i) {
            categoryMap.put(columnIndices[i], new ArrayList());
            categories.put(columnIndices[i], new HashSet());
        }
        while (recordReader.hasNext()) {
            List<Writable> next = recordReader.next();
            for (int i2 = 0; i2 < columnIndices.length; ++i2) {
                if (columnIndices[i2] >= next.size()) {
                    log.warn("Filtering out example: Invalid length of columns");
                    continue;
                }
                ((Set)categories.get(columnIndices[i2])).add(next.get(columnIndices[i2]).toString());
            }
        }
        for (i = 0; i < columnIndices.length; ++i) {
            ((List)categoryMap.get(columnIndices[i])).addAll((Collection)categories.get(columnIndices[i]));
            Collections.sort((List)categoryMap.get(columnIndices[i]));
        }
        return categoryMap;
    }

    public List<List<Writable>> transformRawStringsToInputSequence(List<List<String>> sequence) {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        for (List<String> input : sequence) {
            ret.add(this.transformRawStringsToInputList(input));
        }
        return ret;
    }

    public List<Writable> transformRawStringsToInputList(List<String> values) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (values.size() != this.initialSchema.numColumns()) {
            throw new IllegalArgumentException(String.format("Number of values %d does not match the number of input columns %d for schema", values.size(), this.initialSchema.numColumns()));
        }
        block10: for (int i = 0; i < values.size(); ++i) {
            switch (this.initialSchema.getType(i)) {
                case String: {
                    ret.add(new Text(values.get(i)));
                    continue block10;
                }
                case Integer: {
                    ret.add(new IntWritable(Integer.parseInt(values.get(i))));
                    continue block10;
                }
                case Double: {
                    ret.add(new DoubleWritable(Double.parseDouble(values.get(i))));
                    continue block10;
                }
                case Float: {
                    ret.add(new FloatWritable(Float.parseFloat(values.get(i))));
                    continue block10;
                }
                case Categorical: {
                    ret.add(new Text(values.get(i)));
                    continue block10;
                }
                case Boolean: {
                    ret.add(new BooleanWritable(Boolean.parseBoolean(values.get(i))));
                    continue block10;
                }
                case Time: {
                    continue block10;
                }
                case Long: {
                    ret.add(new LongWritable(Long.parseLong(values.get(i))));
                }
            }
        }
        return ret;
    }

    public List<Writable> transformRawStringsToInput(String ... values) {
        return this.transformRawStringsToInputList(Arrays.asList(values));
    }

    public Schema getInitialSchema() {
        return this.initialSchema;
    }

    public void setActionList(List<DataAction> actionList) {
        this.actionList = actionList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformProcess)) {
            return false;
        }
        TransformProcess other = (TransformProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$initialSchema = this.getInitialSchema();
        Schema other$initialSchema = other.getInitialSchema();
        if (this$initialSchema == null ? other$initialSchema != null : !((Object)this$initialSchema).equals(other$initialSchema)) {
            return false;
        }
        List<DataAction> this$actionList = this.getActionList();
        List<DataAction> other$actionList = other.getActionList();
        return !(this$actionList == null ? other$actionList != null : !((Object)this$actionList).equals(other$actionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $initialSchema = this.getInitialSchema();
        result = result * 59 + ($initialSchema == null ? 43 : ((Object)$initialSchema).hashCode());
        List<DataAction> $actionList = this.getActionList();
        result = result * 59 + ($actionList == null ? 43 : ((Object)$actionList).hashCode());
        return result;
    }

    public String toString() {
        return "TransformProcess(initialSchema=" + this.getInitialSchema() + ", actionList=" + this.getActionList() + ")";
    }

    public static class Builder {
        private List<DataAction> actionList = new ArrayList<DataAction>();
        private Schema initialSchema;

        public Builder(Schema initialSchema) {
            this.initialSchema = initialSchema;
        }

        public Builder transform(Transform transform) {
            this.actionList.add(new DataAction(transform));
            return this;
        }

        public Builder filter(Filter filter) {
            this.actionList.add(new DataAction(filter));
            return this;
        }

        public Builder filter(Condition condition) {
            return this.filter(new ConditionFilter(condition));
        }

        public Builder removeColumns(String ... columnNames) {
            return this.transform(new RemoveColumnsTransform(columnNames));
        }

        public Builder removeColumns(Collection<String> columnNames) {
            return this.transform(new RemoveColumnsTransform(columnNames.toArray(new String[columnNames.size()])));
        }

        public Builder removeAllColumnsExceptFor(String ... columnNames) {
            return this.transform(new RemoveAllColumnsExceptForTransform(columnNames));
        }

        public Builder removeAllColumnsExceptFor(Collection<String> columnNames) {
            return this.removeAllColumnsExceptFor(columnNames.toArray(new String[columnNames.size()]));
        }

        public Builder renameColumn(String oldName, String newName) {
            return this.transform(new RenameColumnsTransform(oldName, newName));
        }

        public Builder renameColumns(List<String> oldNames, List<String> newNames) {
            return this.transform(new RenameColumnsTransform(oldNames, newNames));
        }

        public Builder reorderColumns(String ... newOrder) {
            return this.transform(new ReorderColumnsTransform(newOrder));
        }

        public Builder duplicateColumn(String column, String newName) {
            return this.transform(new DuplicateColumnsTransform(Collections.singletonList(column), Collections.singletonList(newName)));
        }

        public Builder duplicateColumns(List<String> columnNames, List<String> newNames) {
            return this.transform(new DuplicateColumnsTransform(columnNames, newNames));
        }

        public Builder integerMathOp(String column, MathOp mathOp, int scalar) {
            return this.transform(new IntegerMathOpTransform(column, mathOp, scalar));
        }

        public Builder integerColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new IntegerColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder longMathOp(String columnName, MathOp mathOp, long scalar) {
            return this.transform(new LongMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder longColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new LongColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder floatMathOp(String columnName, MathOp mathOp, float scalar) {
            return this.transform(new FloatMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder floatColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new FloatColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder floatMathFunction(String columnName, MathFunction mathFunction) {
            return this.transform(new FloatMathFunctionTransform(columnName, mathFunction));
        }

        public Builder doubleMathOp(String columnName, MathOp mathOp, double scalar) {
            return this.transform(new DoubleMathOpTransform(columnName, mathOp, scalar));
        }

        public Builder doubleColumnsMathOp(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new DoubleColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder doubleMathFunction(String columnName, MathFunction mathFunction) {
            return this.transform(new DoubleMathFunctionTransform(columnName, mathFunction));
        }

        public Builder timeMathOp(String columnName, MathOp mathOp, long timeQuantity, TimeUnit timeUnit) {
            return this.transform(new TimeMathOpTransform(columnName, mathOp, timeQuantity, timeUnit));
        }

        public Builder categoricalToOneHot(String ... columnNames) {
            for (String s : columnNames) {
                this.transform(new CategoricalToOneHotTransform(s));
            }
            return this;
        }

        public Builder categoricalToInteger(String ... columnNames) {
            for (String s : columnNames) {
                this.transform(new CategoricalToIntegerTransform(s));
            }
            return this;
        }

        public Builder integerToCategorical(String columnName, List<String> categoryStateNames) {
            return this.transform(new IntegerToCategoricalTransform(columnName, categoryStateNames));
        }

        public Builder integerToCategorical(String columnName, Map<Integer, String> categoryIndexNameMap) {
            return this.transform(new IntegerToCategoricalTransform(columnName, categoryIndexNameMap));
        }

        public Builder integerToOneHot(String columnName, int minValue, int maxValue) {
            return this.transform(new IntegerToOneHotTransform(columnName, minValue, maxValue));
        }

        public Builder addConstantColumn(String newColumnName, ColumnType newColumnType, Writable fixedValue) {
            return this.transform(new AddConstantColumnTransform(newColumnName, newColumnType, fixedValue));
        }

        public Builder addConstantDoubleColumn(String newColumnName, double value) {
            return this.addConstantColumn(newColumnName, ColumnType.Double, new DoubleWritable(value));
        }

        public Builder addConstantIntegerColumn(String newColumnName, int value) {
            return this.addConstantColumn(newColumnName, ColumnType.Integer, new IntWritable(value));
        }

        public Builder addConstantLongColumn(String newColumnName, long value) {
            return this.addConstantColumn(newColumnName, ColumnType.Long, new LongWritable(value));
        }

        public Builder convertToString(String inputColumn) {
            return this.transform(new ConvertToString(inputColumn));
        }

        public Builder convertToDouble(String inputColumn) {
            return this.transform(new ConvertToDouble(inputColumn));
        }

        public Builder convertToInteger(String inputColumn) {
            return this.transform(new ConvertToInteger(inputColumn));
        }

        public Builder normalize(String column, Normalize type, DataAnalysis da) {
            ColumnAnalysis ca = da.getColumnAnalysis(column);
            if (!(ca instanceof NumericalColumnAnalysis)) {
                throw new IllegalStateException("Column \"" + column + "\" analysis is not numerical. Column is not numerical?");
            }
            NumericalColumnAnalysis nca = (NumericalColumnAnalysis)ca;
            double min = nca.getMinDouble();
            double max = nca.getMaxDouble();
            double mean = nca.getMean();
            double sigma = nca.getSampleStdev();
            switch (type) {
                case MinMax: {
                    return this.transform(new MinMaxNormalizer(column, min, max));
                }
                case MinMax2: {
                    return this.transform(new MinMaxNormalizer(column, min, max, -1.0, 1.0));
                }
                case Standardize: {
                    return this.transform(new StandardizeNormalizer(column, mean, sigma));
                }
                case SubtractMean: {
                    return this.transform(new SubtractMeanNormalizer(column, mean));
                }
                case Log2Mean: {
                    return this.transform(new Log2Normalizer(column, mean, min, 0.5));
                }
                case Log2MeanExcludingMin: {
                    double meanExMin;
                    long countMin = nca.getCountMinValue();
                    if (ca.getCountTotal() - countMin == 0L) {
                        if (ca.getCountTotal() == 0L) {
                            log.warn("Normalizing with Log2MeanExcludingMin but 0 records present in analysis");
                        } else {
                            log.warn("Normalizing with Log2MeanExcludingMin but all records are the same value");
                        }
                        meanExMin = mean;
                    } else {
                        meanExMin = (mean * (double)ca.getCountTotal() - (double)countMin * min) / (double)(ca.getCountTotal() - countMin);
                    }
                    return this.transform(new Log2Normalizer(column, meanExMin, min, 0.5));
                }
            }
            throw new RuntimeException("Unknown/not implemented normalization type: " + (Object)((Object)type));
        }

        public Builder convertToSequence(String keyColumn, SequenceComparator comparator) {
            this.actionList.add(new DataAction(new ConvertToSequence(keyColumn, comparator)));
            return this;
        }

        public Builder convertToSequence() {
            this.actionList.add(new DataAction(new ConvertToSequence(true, null, null)));
            return this;
        }

        public Builder convertToSequence(List<String> keyColumns, SequenceComparator comparator) {
            this.actionList.add(new DataAction(new ConvertToSequence(keyColumns, comparator)));
            return this;
        }

        public Builder convertFromSequence() {
            this.actionList.add(new DataAction(new ConvertFromSequence()));
            return this;
        }

        public Builder splitSequence(SequenceSplit split) {
            this.actionList.add(new DataAction(split));
            return this;
        }

        public Builder trimSequence(int numStepsToTrim, boolean trimFromStart) {
            this.actionList.add(new DataAction(new SequenceTrimTransform(numStepsToTrim, trimFromStart)));
            return this;
        }

        public Builder offsetSequence(List<String> columnsToOffset, int offsetAmount, SequenceOffsetTransform.OperationType operationType) {
            return this.transform(new SequenceOffsetTransform(columnsToOffset, offsetAmount, operationType, SequenceOffsetTransform.EdgeHandling.TrimSequence, null));
        }

        public Builder reduce(IAssociativeReducer reducer) {
            this.actionList.add(new DataAction(reducer));
            return this;
        }

        public Builder reduceSequence(IAssociativeReducer reducer) {
            this.actionList.add(new DataAction(new ReduceSequenceTransform(reducer)));
            this.convertFromSequence();
            return this;
        }

        public Builder reduceSequenceByWindow(IAssociativeReducer reducer, WindowFunction windowFunction) {
            this.actionList.add(new DataAction(new ReduceSequenceByWindowTransform(reducer, windowFunction)));
            return this;
        }

        public Builder sequenceMovingWindowReduce(String columnName, int lookback, ReduceOp op) {
            this.actionList.add(new DataAction(new SequenceMovingWindowReduceTransform(columnName, lookback, op)));
            return this;
        }

        public Builder calculateSortedRank(String newColumnName, String sortOnColumn, WritableComparator comparator) {
            this.actionList.add(new DataAction(new CalculateSortedRank(newColumnName, sortOnColumn, comparator)));
            return this;
        }

        public Builder calculateSortedRank(String newColumnName, String sortOnColumn, WritableComparator comparator, boolean ascending) {
            this.actionList.add(new DataAction(new CalculateSortedRank(newColumnName, sortOnColumn, comparator, ascending)));
            return this;
        }

        public Builder stringToCategorical(String columnName, List<String> stateNames) {
            return this.transform(new StringToCategoricalTransform(columnName, stateNames));
        }

        public Builder stringRemoveWhitespaceTransform(String columnName) {
            return this.transform(new RemoveWhiteSpaceTransform(columnName));
        }

        public Builder stringMapTransform(String columnName, Map<String, String> mapping) {
            return this.transform(new StringMapTransform(columnName, mapping));
        }

        public Builder stringToTimeTransform(String column, String format, DateTimeZone dateTimeZone) {
            return this.transform(new StringToTimeTransform(column, format, dateTimeZone));
        }

        public Builder stringToTimeTransform(String column, String format, DateTimeZone dateTimeZone, Locale locale) {
            return this.transform(new StringToTimeTransform(column, format, dateTimeZone, locale));
        }

        public Builder appendStringColumnTransform(String column, String toAppend) {
            return this.transform(new AppendStringColumnTransform(column, toAppend));
        }

        public Builder conditionalReplaceValueTransform(String column, Writable newValue, Condition condition) {
            return this.transform(new ConditionalReplaceValueTransform(column, newValue, condition));
        }

        public Builder conditionalReplaceValueTransformWithDefault(String column, Writable yesVal, Writable noVal, Condition condition) {
            return this.transform(new ConditionalReplaceValueTransformWithDefault(column, yesVal, noVal, condition));
        }

        public Builder conditionalCopyValueTransform(String columnToReplace, String sourceColumn, Condition condition) {
            return this.transform(new ConditionalCopyValueTransform(columnToReplace, sourceColumn, condition));
        }

        public Builder replaceStringTransform(String columnName, Map<String, String> mapping) {
            return this.transform(new ReplaceStringTransform(columnName, mapping));
        }

        public Builder ndArrayScalarOpTransform(String columnName, MathOp op, double value) {
            return this.transform(new NDArrayScalarOpTransform(columnName, op, value));
        }

        public Builder ndArrayColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columnNames) {
            return this.transform(new NDArrayColumnsMathOpTransform(newColumnName, mathOp, columnNames));
        }

        public Builder ndArrayMathFunctionTransform(String columnName, MathFunction mathFunction) {
            return this.transform(new NDArrayMathFunctionTransform(columnName, mathFunction));
        }

        public Builder ndArrayDistanceTransform(String newColumnName, Distance distance, String firstCol, String secondCol) {
            return this.transform(new NDArrayDistanceTransform(newColumnName, distance, firstCol, secondCol));
        }

        public Builder firstDigitTransform(String inputColumn, String outputColumn) {
            return this.firstDigitTransform(inputColumn, outputColumn, FirstDigitTransform.Mode.INCLUDE_OTHER_CATEGORY);
        }

        public Builder firstDigitTransform(String inputColumn, String outputColumn, FirstDigitTransform.Mode mode) {
            return this.transform(new FirstDigitTransform(inputColumn, outputColumn, mode));
        }

        public TransformProcess build() {
            return new TransformProcess(this);
        }
    }
}

