/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ui.components;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ui.components.RenderableComponent;

public class RenderableComponentLineChart
extends RenderableComponent {
    public static final String COMPONENT_TYPE = "linechart";
    private String title;
    private List<double[]> x;
    private List<double[]> y;
    private List<String> seriesNames;
    private boolean removeAxisHorizontal;
    private int marginTop;
    private int marginBottom;
    private int marginLeft;
    private int marginRight;
    private boolean legend;

    private RenderableComponentLineChart(Builder builder) {
        super(COMPONENT_TYPE);
        this.title = builder.title;
        this.x = builder.x;
        this.y = builder.y;
        this.seriesNames = builder.seriesNames;
        this.removeAxisHorizontal = builder.removeAxisHorizontal;
        this.marginTop = builder.marginTop;
        this.marginBottom = builder.marginBottom;
        this.marginLeft = builder.marginLeft;
        this.marginRight = builder.marginRight;
    }

    public RenderableComponentLineChart() {
        super(COMPONENT_TYPE);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderableComponentLineChart)) {
            return false;
        }
        RenderableComponentLineChart other = (RenderableComponentLineChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<double[]> this$x = this.getX();
        List<double[]> other$x = other.getX();
        if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
            return false;
        }
        List<double[]> this$y = this.getY();
        List<double[]> other$y = other.getY();
        if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
            return false;
        }
        List<String> this$seriesNames = this.getSeriesNames();
        List<String> other$seriesNames = other.getSeriesNames();
        if (this$seriesNames == null ? other$seriesNames != null : !((Object)this$seriesNames).equals(other$seriesNames)) {
            return false;
        }
        if (this.isRemoveAxisHorizontal() != other.isRemoveAxisHorizontal()) {
            return false;
        }
        if (this.getMarginTop() != other.getMarginTop()) {
            return false;
        }
        if (this.getMarginBottom() != other.getMarginBottom()) {
            return false;
        }
        if (this.getMarginLeft() != other.getMarginLeft()) {
            return false;
        }
        if (this.getMarginRight() != other.getMarginRight()) {
            return false;
        }
        return this.isLegend() == other.isLegend();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RenderableComponentLineChart;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<double[]> $x = this.getX();
        result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
        List<double[]> $y = this.getY();
        result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
        List<String> $seriesNames = this.getSeriesNames();
        result = result * 59 + ($seriesNames == null ? 43 : ((Object)$seriesNames).hashCode());
        result = result * 59 + (this.isRemoveAxisHorizontal() ? 79 : 97);
        result = result * 59 + this.getMarginTop();
        result = result * 59 + this.getMarginBottom();
        result = result * 59 + this.getMarginLeft();
        result = result * 59 + this.getMarginRight();
        result = result * 59 + (this.isLegend() ? 79 : 97);
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public List<double[]> getX() {
        return this.x;
    }

    public List<double[]> getY() {
        return this.y;
    }

    public List<String> getSeriesNames() {
        return this.seriesNames;
    }

    public boolean isRemoveAxisHorizontal() {
        return this.removeAxisHorizontal;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setX(List<double[]> x) {
        this.x = x;
    }

    public void setY(List<double[]> y) {
        this.y = y;
    }

    public void setSeriesNames(List<String> seriesNames) {
        this.seriesNames = seriesNames;
    }

    public void setRemoveAxisHorizontal(boolean removeAxisHorizontal) {
        this.removeAxisHorizontal = removeAxisHorizontal;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    @Override
    public String toString() {
        return "RenderableComponentLineChart(title=" + this.getTitle() + ", x=" + this.getX() + ", y=" + this.getY() + ", seriesNames=" + this.getSeriesNames() + ", removeAxisHorizontal=" + this.isRemoveAxisHorizontal() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", legend=" + this.isLegend() + ")";
    }

    public static class Builder {
        private String title;
        private List<double[]> x = new ArrayList<double[]>();
        private List<double[]> y = new ArrayList<double[]>();
        private List<String> seriesNames = new ArrayList<String>();
        private boolean removeAxisHorizontal = false;
        private boolean legend = true;
        private int marginTop = 60;
        private int marginBottom = 60;
        private int marginLeft = 60;
        private int marginRight = 20;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder addSeries(String seriesName, double[] xValues, double[] yValues) {
            this.x.add(xValues);
            this.y.add(yValues);
            this.seriesNames.add(seriesName);
            return this;
        }

        public Builder setRemoveAxisHorizontal(boolean removeAxisHorizontal) {
            this.removeAxisHorizontal = removeAxisHorizontal;
            return this;
        }

        public Builder margins(int top, int bottom, int left, int right) {
            this.marginTop = top;
            this.marginBottom = bottom;
            this.marginLeft = left;
            this.marginRight = right;
            return this;
        }

        public Builder legend(boolean legend) {
            this.legend = legend;
            return this;
        }

        public RenderableComponentLineChart build() {
            return new RenderableComponentLineChart(this);
        }
    }
}

