/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.integer;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.transform.integer.BaseIntegerTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;

public class ConvertToInteger
extends BaseIntegerTransform {
    public ConvertToInteger(String column) {
        super(column);
    }

    @Override
    public IntWritable map(Writable writable) {
        if (writable.getType() == WritableType.Int) {
            return (IntWritable)writable;
        }
        return new IntWritable(writable.toInt());
    }

    @Override
    public Object map(Object input) {
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        return Integer.parseInt(input.toString());
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        return new IntegerMetaData(newColumnName);
    }

    @Override
    public String toString() {
        return "ConvertToInteger(columnName=" + this.columnName + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToInteger)) {
            return false;
        }
        ConvertToInteger other = (ConvertToInteger)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvertToInteger;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }

    public ConvertToInteger() {
    }
}

