/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"ratio", "inputSchema", "columnNumber"})
public class MinMaxNormalizer
extends BaseDoubleTransform {
    protected final double min;
    protected final double max;
    protected final double newMin;
    protected final double newMax;
    protected final double ratio;

    public MinMaxNormalizer(String columnName, double min, double max) {
        this(columnName, min, max, 0.0, 1.0);
    }

    public MinMaxNormalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="newMin") double newMin, @JsonProperty(value="newMax") double newMax) {
        super(columnName);
        this.min = min;
        this.max = max;
        this.newMin = newMin;
        this.newMax = newMax;
        this.ratio = (newMax - newMin) / (max - min);
    }

    @Override
    public Writable map(Writable writable) {
        double val = writable.toDouble();
        if (Double.isNaN(val)) {
            return new DoubleWritable(0.0);
        }
        return new DoubleWritable(this.ratio * (val - this.min) + this.newMin);
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnMeta) {
        return new DoubleMetaData(newColumnName, this.newMin, this.newMax);
    }

    @Override
    public String toString() {
        return "MinMaxNormalizer(min=" + this.min + ",max=" + this.max + ",newMin=" + this.newMin + ",newMax=" + this.newMax + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        double val = n.doubleValue();
        if (Double.isNaN(val)) {
            return new DoubleWritable(0.0);
        }
        return this.ratio * (val - this.min) + this.newMin;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getNewMin() {
        return this.newMin;
    }

    public double getNewMax() {
        return this.newMax;
    }

    public double getRatio() {
        return this.ratio;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinMaxNormalizer)) {
            return false;
        }
        MinMaxNormalizer other = (MinMaxNormalizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewMin(), other.getNewMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getNewMax(), other.getNewMax()) != 0) {
            return false;
        }
        return Double.compare(this.getRatio(), other.getRatio()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MinMaxNormalizer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $newMin = Double.doubleToLongBits(this.getNewMin());
        result = result * 59 + (int)($newMin >>> 32 ^ $newMin);
        long $newMax = Double.doubleToLongBits(this.getNewMax());
        result = result * 59 + (int)($newMax >>> 32 ^ $newMax);
        long $ratio = Double.doubleToLongBits(this.getRatio());
        result = result * 59 + (int)($ratio >>> 32 ^ $ratio);
        return result;
    }
}

