/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.serde;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.condition.column.ColumnCondition;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.transform.serde.legacy.LegacyMappingHelper;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.annotation.PropertyAccessor;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.databind.AnnotationIntrospector;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.introspect.Annotated;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedClass;
import org.nd4j.shade.jackson.databind.introspect.AnnotationMap;
import org.nd4j.shade.jackson.databind.introspect.JacksonAnnotationIntrospector;
import org.nd4j.shade.jackson.databind.jsontype.TypeResolverBuilder;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.nd4j.shade.jackson.datatype.joda.JodaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMappers {
    private static final Logger log = LoggerFactory.getLogger(JsonMappers.class);
    public static String CUSTOM_REGISTRATION_PROPERTY = "org.datavec.config.custom.legacyclasses";
    private static ObjectMapper jsonMapper;
    private static ObjectMapper yamlMapper;
    private static Map<Class, ObjectMapper> legacyMappers;
    private static List<Class<?>> REGISTERABLE_CUSTOM_CLASSES;

    public static void registerLegacyCustomClassesForJSON(Class<?> ... classes) {
        JsonMappers.registerLegacyCustomClassesForJSONList(Arrays.asList(classes));
    }

    public static void registerLegacyCustomClassesForJSONList(List<Class<?>> classes) {
        ArrayList<Pair<String, Class>> list = new ArrayList<Pair<String, Class>>();
        for (Class<?> c : classes) {
            list.add((Pair<String, Class>)new Pair((Object)c.getSimpleName(), c));
        }
        JsonMappers.registerLegacyCustomClassesForJSON(list);
    }

    public static void registerLegacyCustomClassesForJSON(List<Pair<String, Class>> classes) {
        for (Pair<String, Class> p : classes) {
            String s = (String)p.getFirst();
            Class c = (Class)p.getRight();
            boolean found = false;
            for (Class<?> c2 : REGISTERABLE_CUSTOM_CLASSES) {
                if (!c2.isAssignableFrom(c)) continue;
                Map<String, String> map = LegacyMappingHelper.legacyMappingForClass(c2);
                map.put((String)p.getFirst(), ((Class)p.getSecond()).getName());
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot register class for legacy JSON deserialization: class " + c.getName() + " is not a subtype of classes " + REGISTERABLE_CUSTOM_CLASSES);
        }
    }

    public static synchronized ObjectMapper getLegacyMapperFor(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (!legacyMappers.containsKey(clazz)) {
            ObjectMapper m = new ObjectMapper();
            JsonMappers.configureMapper(m);
            m.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(clazz)));
            legacyMappers.put(clazz, m);
        }
        return legacyMappers.get(clazz);
    }

    public static ObjectMapper getMapper() {
        return jsonMapper;
    }

    public static ObjectMapper getMapperYaml() {
        return yamlMapper;
    }

    private static void configureMapper(ObjectMapper ret) {
        ret.registerModule((Module)new JodaModule());
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        ret.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        ret.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    static {
        String p = System.getProperty(CUSTOM_REGISTRATION_PROPERTY);
        if (p != null && !p.isEmpty()) {
            String[] split = p.split(",");
            ArrayList list = new ArrayList();
            for (String s : split) {
                try {
                    Class<?> c = Class.forName(s);
                    list.add(c);
                }
                catch (Throwable t) {
                    log.warn("Error parsing {} system property: class \"{}\" could not be loaded", new Object[]{CUSTOM_REGISTRATION_PROPERTY, s, t});
                }
            }
            if (list.size() > 0) {
                try {
                    JsonMappers.registerLegacyCustomClassesForJSONList(list);
                }
                catch (Throwable t) {
                    log.warn("Error registering custom classes for legacy JSON deserialization ({} system property)", (Object)CUSTOM_REGISTRATION_PROPERTY, (Object)t);
                }
            }
        }
        jsonMapper = new ObjectMapper();
        yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonMappers.configureMapper(jsonMapper);
        JsonMappers.configureMapper(yamlMapper);
        legacyMappers = new ConcurrentHashMap<Class, ObjectMapper>();
        REGISTERABLE_CUSTOM_CLASSES = Arrays.asList(Transform.class, ColumnAnalysis.class, ColumnCondition.class, Filter.class, ColumnMetaData.class, CalculateSortedRank.class, Schema.class, SequenceComparator.class, SequenceSplit.class, WindowFunction.class, Writable.class, WritableComparator.class);
    }

    private static class IgnoreJsonTypeInfoIntrospector
    extends JacksonAnnotationIntrospector {
        private List<Class> classList;

        protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
            if (ann instanceof AnnotatedClass) {
                AnnotatedClass c = (AnnotatedClass)ann;
                Class annClass = c.getAnnotated();
                boolean isAssignable = false;
                for (Class c2 : this.classList) {
                    if (!c2.isAssignableFrom(annClass)) continue;
                    isAssignable = true;
                    break;
                }
                if (isAssignable) {
                    AnnotationMap annotations = (AnnotationMap)((AnnotatedClass)ann).getAnnotations();
                    if (annotations == null || annotations.annotations() == null) {
                        return super._findTypeResolver(config, ann, baseType);
                    }
                    AnnotationMap newMap = null;
                    for (Annotation a : annotations.annotations()) {
                        Class<? extends Annotation> annType = a.annotationType();
                        if (annType == JsonTypeInfo.class) continue;
                        if (newMap == null) {
                            newMap = new AnnotationMap();
                        }
                        newMap.add(a);
                    }
                    if (newMap == null) {
                        return null;
                    }
                    AnnotatedClass ann2 = c.withAnnotations(newMap);
                    return super._findTypeResolver(config, (Annotated)ann2, baseType);
                }
            }
            return super._findTypeResolver(config, ann, baseType);
        }

        public IgnoreJsonTypeInfoIntrospector(List<Class> classList) {
            this.classList = classList;
        }
    }
}

