/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.expansion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(value={"inputSchema"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BaseSequenceExpansionTransform
implements Transform {
    protected List<String> requiredColumns;
    protected List<String> expandedColumnNames;
    protected Schema inputSchema;

    protected BaseSequenceExpansionTransform(@NonNull List<String> requiredColumns, @NonNull List<String> expandedColumnNames) {
        if (requiredColumns == null) {
            throw new NullPointerException("requiredColumns");
        }
        if (expandedColumnNames == null) {
            throw new NullPointerException("expandedColumnNames");
        }
        if (requiredColumns.size() == 0) {
            throw new IllegalArgumentException("No columns have values to be expanded. Must have requiredColumns.size() > 0");
        }
        this.requiredColumns = requiredColumns;
        this.expandedColumnNames = expandedColumnNames;
    }

    protected abstract List<ColumnMetaData> expandedColumnMetaDatas(List<ColumnMetaData> var1, List<String> var2);

    protected abstract List<List<Writable>> expandTimeStep(List<Writable> var1);

    @Override
    public Schema transform(Schema inputSchema) {
        ArrayList<ColumnMetaData> meta = new ArrayList<ColumnMetaData>(inputSchema.numColumns());
        ArrayList<ColumnMetaData> oldMetaToExpand = new ArrayList<ColumnMetaData>();
        for (String s : this.requiredColumns) {
            oldMetaToExpand.add(inputSchema.getMetaData(s));
        }
        List<ColumnMetaData> newMetaToExpand = this.expandedColumnMetaDatas(oldMetaToExpand, this.expandedColumnNames);
        int modColumnIdx = 0;
        for (ColumnMetaData m : inputSchema.getColumnMetaData()) {
            if (this.requiredColumns.contains(m.getName())) {
                meta.add(newMetaToExpand.get(modColumnIdx++));
                continue;
            }
            meta.add(m);
        }
        return inputSchema.newSchema(meta);
    }

    @Override
    public String outputColumnName() {
        return this.expandedColumnNames.get(0);
    }

    @Override
    public String[] outputColumnNames() {
        return this.expandedColumnNames.toArray(new String[this.requiredColumns.size()]);
    }

    @Override
    public String[] columnNames() {
        return this.requiredColumns.toArray(new String[this.requiredColumns.size()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("Cannot perform sequence expansion on non-sequence data");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        int nCols = this.inputSchema.numColumns();
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        HashMap<Integer, Integer> expandColumnIdxsMap = new HashMap<Integer, Integer>();
        int[] expandColumnIdxs = new int[this.requiredColumns.size()];
        int count = 0;
        for (String s : this.requiredColumns) {
            int idx = this.inputSchema.getIndexOfColumn(s);
            expandColumnIdxsMap.put(idx, count);
            expandColumnIdxs[count++] = idx;
        }
        ArrayList<Writable> toExpand = new ArrayList<Writable>(this.requiredColumns.size());
        for (List<Writable> step : sequence) {
            toExpand.clear();
            for (int i : expandColumnIdxs) {
                toExpand.add(step.get(i));
            }
            List<List<Writable>> expanded = this.expandTimeStep(toExpand);
            int expansionSize = expanded.size();
            for (int i = 0; i < expansionSize; ++i) {
                ArrayList<Writable> newStep = new ArrayList<Writable>(nCols);
                for (int j = 0; j < nCols; ++j) {
                    if (expandColumnIdxsMap.containsKey(j)) {
                        int expandIdx = (Integer)expandColumnIdxsMap.get(j);
                        newStep.add(expanded.get(i).get(expandIdx));
                        continue;
                    }
                    newStep.add(step.get(j));
                }
                out.add(newStep);
            }
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseSequenceExpansionTransform)) {
            return false;
        }
        BaseSequenceExpansionTransform other = (BaseSequenceExpansionTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$requiredColumns = this.getRequiredColumns();
        List<String> other$requiredColumns = other.getRequiredColumns();
        if (this$requiredColumns == null ? other$requiredColumns != null : !((Object)this$requiredColumns).equals(other$requiredColumns)) {
            return false;
        }
        List<String> this$expandedColumnNames = this.getExpandedColumnNames();
        List<String> other$expandedColumnNames = other.getExpandedColumnNames();
        return !(this$expandedColumnNames == null ? other$expandedColumnNames != null : !((Object)this$expandedColumnNames).equals(other$expandedColumnNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseSequenceExpansionTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $requiredColumns = this.getRequiredColumns();
        result = result * 59 + ($requiredColumns == null ? 43 : ((Object)$requiredColumns).hashCode());
        List<String> $expandedColumnNames = this.getExpandedColumnNames();
        result = result * 59 + ($expandedColumnNames == null ? 43 : ((Object)$expandedColumnNames).hashCode());
        return result;
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public List<String> getExpandedColumnNames() {
        return this.expandedColumnNames;
    }

    public void setRequiredColumns(List<String> requiredColumns) {
        this.requiredColumns = requiredColumns;
    }

    public void setExpandedColumnNames(List<String> expandedColumnNames) {
        this.expandedColumnNames = expandedColumnNames;
    }

    public String toString() {
        return "BaseSequenceExpansionTransform(requiredColumns=" + this.getRequiredColumns() + ", expandedColumnNames=" + this.getExpandedColumnNames() + ", inputSchema=" + this.getInputSchema() + ")";
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }
}

