/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import com.google.common.math.DoubleMath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ByteWritable
implements WritableComparable {
    private byte value;

    public ByteWritable() {
    }

    public ByteWritable(@JsonProperty(value="value") byte value) {
        this.set(value);
    }

    public void set(byte value) {
        this.value = value;
    }

    public byte get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(WritableType.Byte.typeIdx());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public boolean fuzzyEquals(Writable o, double tolerance) {
        double other;
        if (o instanceof IntWritable) {
            other = ((IntWritable)o).toDouble();
        } else if (o instanceof LongWritable) {
            other = ((LongWritable)o).toDouble();
        } else if (o instanceof ByteWritable) {
            other = ((ByteWritable)o).toDouble();
        } else if (o instanceof DoubleWritable) {
            other = ((DoubleWritable)o).toDouble();
        } else if (o instanceof FloatWritable) {
            other = ((FloatWritable)o).toDouble();
        } else {
            return false;
        }
        return DoubleMath.fuzzyEquals((double)this.value, (double)other, (double)tolerance);
    }

    public boolean equals(Object o) {
        if (o instanceof IntWritable || o instanceof LongWritable) {
            return new IntWritable(this.value).equals(o);
        }
        if (o instanceof ByteWritable) {
            ByteWritable other = (ByteWritable)o;
            return this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(Object o) {
        byte thisValue = this.value;
        byte thatValue = ((ByteWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public int toInt() {
        return this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public WritableType getType() {
        return WritableType.Byte;
    }

    static {
        WritableComparator.define(ByteWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ByteWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            byte thisValue = b1[s1];
            byte thatValue = b2[s2];
            return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

