/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.datavec.api.conf.Configurable;
import org.datavec.api.conf.Configuration;
import org.datavec.api.io.DataInputBuffer;
import org.datavec.api.io.DataOutputBuffer;
import org.datavec.api.io.serializers.Deserializer;
import org.datavec.api.io.serializers.SerializationFactory;
import org.datavec.api.io.serializers.Serializer;

@Deprecated
public class ReflectionUtils
extends org.nd4j.util.ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static SerializationFactory serialFactory = null;
    private static ThreadLocal<CopyInCopyOutBuffer> cloneBuffers = new ThreadLocal<CopyInCopyOutBuffer>(){

        @Override
        protected synchronized CopyInCopyOutBuffer initialValue() {
            return new CopyInCopyOutBuffer();
        }
    };

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        T result;
        try {
            Constructor<T> meth = (Constructor<T>)CONSTRUCTOR_CACHE.get(theClass);
            if (meth == null) {
                meth = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf(result, conf);
        return result;
    }

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                ((Configurable)theObject).setConf(conf);
            }
            ReflectionUtils.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        try {
            Class<?> jobConfClass = conf.getClassByName("org.apache.hadoop.mapred.JobConf");
            Class<?> jobConfigurableClass = conf.getClassByName("org.apache.hadoop.mapred.JobConfigurable");
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                Method configureMethod = jobConfigurableClass.getMethod("configure", jobConfClass);
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (ClassNotFoundException jobConfClass) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    private static SerializationFactory getFactory(Configuration conf) {
        if (serialFactory == null) {
            serialFactory = new SerializationFactory(conf);
        }
        return serialFactory;
    }

    public static <T> T copy(Configuration conf, T src, T dst) throws IOException {
        CopyInCopyOutBuffer buffer = cloneBuffers.get();
        buffer.outBuffer.reset();
        SerializationFactory factory = ReflectionUtils.getFactory(conf);
        Class<?> cls = src.getClass();
        Serializer<?> serializer = factory.getSerializer(cls);
        serializer.open(buffer.outBuffer);
        serializer.serialize(src);
        buffer.moveData();
        Deserializer<?> deserializer = factory.getDeserializer(cls);
        deserializer.open(buffer.inBuffer);
        dst = deserializer.deserialize(dst);
        return dst;
    }

    private static class CopyInCopyOutBuffer {
        DataOutputBuffer outBuffer = new DataOutputBuffer();
        DataInputBuffer inBuffer = new DataInputBuffer();

        private CopyInCopyOutBuffer() {
        }

        void moveData() {
            this.inBuffer.reset(this.outBuffer.getData(), this.outBuffer.getLength());
        }
    }
}

