/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class SubtractMeanNormalizer
extends BaseDoubleTransform {
    private final double mean;

    public SubtractMeanNormalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mean") double mean) {
        super(columnName);
        this.mean = mean;
    }

    @Override
    public Writable map(Writable writable) {
        return new DoubleWritable(writable.toDouble() - this.mean);
    }

    @Override
    public String toString() {
        return "SubstractMeanNormalizer(mean=" + this.mean + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        return n.doubleValue() - this.mean;
    }
}

