/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.stringreduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datavec.api.transform.StringReduceOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.reduce.ColumnReduction;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.stringreduce.IStringReducer;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"schema", "keyColumnsSet"})
public class StringReducer
implements IStringReducer {
    private Schema schema;
    private final List<String> inputColumns;
    private final Set<String> inputColumnsSet;
    private String outputColumnName;
    private final StringReduceOp stringReduceOp;
    private Map<String, ColumnReduction> customReductions;

    private StringReducer(Builder builder) {
        this(builder.inputColumns, builder.defaultOp, builder.customReductions, builder.outputColumnName);
    }

    public StringReducer(@JsonProperty(value="inputColumns") List<String> inputColumns, @JsonProperty(value="op") StringReduceOp stringReduceOp, @JsonProperty(value="customReductions") Map<String, ColumnReduction> customReductions, @JsonProperty(value="outputColumnName") String outputColumnName) {
        this.inputColumns = inputColumns;
        this.inputColumnsSet = inputColumns == null ? null : new HashSet<String>(inputColumns);
        this.stringReduceOp = stringReduceOp;
        this.customReductions = customReductions;
        this.outputColumnName = outputColumnName;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public List<String> getInputColumns() {
        return this.inputColumns;
    }

    @Override
    public Schema transform(Schema schema) {
        int nCols = schema.numColumns();
        List<ColumnMetaData> meta = schema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(nCols);
        newMeta.addAll(meta);
        newMeta.add(new StringMetaData(this.outputColumnName));
        return schema.newSchema(newMeta);
    }

    private static ColumnMetaData getMetaForColumn(StringReduceOp op, String name, ColumnMetaData inMeta) {
        inMeta = inMeta.clone();
        switch (op) {
            case PREPEND: {
                inMeta.setName("prepend(" + name + ")");
                return inMeta;
            }
            case APPEND: {
                inMeta.setName("append(" + name + ")");
                return inMeta;
            }
            case REPLACE: {
                inMeta.setName("replace(" + name + ")");
                return inMeta;
            }
            case MERGE: {
                inMeta.setName("merge(" + name + ")");
                return inMeta;
            }
        }
        throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)op));
    }

    @Override
    public List<Writable> reduce(List<List<Writable>> examplesList) {
        if (this.schema == null) {
            throw new IllegalStateException("Error: Schema has not been set");
        }
        ArrayList<Writable> out = new ArrayList<Writable>(examplesList.size());
        for (int i = 0; i < examplesList.size(); ++i) {
            out.add(StringReducer.reduceStringOrCategoricalColumn(this.stringReduceOp, examplesList.get(i)));
        }
        return out;
    }

    public static Writable reduceStringOrCategoricalColumn(StringReduceOp op, List<Writable> values) {
        switch (op) {
            case APPEND: 
            case MERGE: {
                StringBuilder stringBuilder = new StringBuilder();
                for (Writable w : values) {
                    stringBuilder.append(w.toString());
                }
                return new Text(stringBuilder.toString());
            }
            case REPLACE: {
                if (values.size() > 2) {
                    throw new IllegalArgumentException("Unable to run replace on columns > 2");
                }
                return new Text(values.get(1).toString());
            }
            case PREPEND: {
                ArrayList<Writable> reverse = new ArrayList<Writable>(values);
                Collections.reverse(reverse);
                StringBuilder stringBuilder2 = new StringBuilder();
                for (Writable w : reverse) {
                    stringBuilder2.append(w.toString());
                }
                return new Text(stringBuilder2.toString());
            }
        }
        throw new UnsupportedOperationException("Cannot execute op \"" + (Object)((Object)op) + "\" on String/Categorical column (can only perform Count, CountUnique, TakeFirst and TakeLast ops on categorical columns)");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StringReducer(");
        sb.append("defaultOp=").append((Object)this.stringReduceOp);
        if (this.customReductions != null) {
            sb.append(",customReductions=").append(this.customReductions);
        }
        sb.append(")");
        return sb.toString();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Set<String> getInputColumnsSet() {
        return this.inputColumnsSet;
    }

    public String getOutputColumnName() {
        return this.outputColumnName;
    }

    public StringReduceOp getStringReduceOp() {
        return this.stringReduceOp;
    }

    public Map<String, ColumnReduction> getCustomReductions() {
        return this.customReductions;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setOutputColumnName(String outputColumnName) {
        this.outputColumnName = outputColumnName;
    }

    public void setCustomReductions(Map<String, ColumnReduction> customReductions) {
        this.customReductions = customReductions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringReducer)) {
            return false;
        }
        StringReducer other = (StringReducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$inputColumns = this.getInputColumns();
        List<String> other$inputColumns = other.getInputColumns();
        if (this$inputColumns == null ? other$inputColumns != null : !((Object)this$inputColumns).equals(other$inputColumns)) {
            return false;
        }
        Set<String> this$inputColumnsSet = this.getInputColumnsSet();
        Set<String> other$inputColumnsSet = other.getInputColumnsSet();
        if (this$inputColumnsSet == null ? other$inputColumnsSet != null : !((Object)this$inputColumnsSet).equals(other$inputColumnsSet)) {
            return false;
        }
        String this$outputColumnName = this.getOutputColumnName();
        String other$outputColumnName = other.getOutputColumnName();
        if (this$outputColumnName == null ? other$outputColumnName != null : !this$outputColumnName.equals(other$outputColumnName)) {
            return false;
        }
        StringReduceOp this$stringReduceOp = this.getStringReduceOp();
        StringReduceOp other$stringReduceOp = other.getStringReduceOp();
        if (this$stringReduceOp == null ? other$stringReduceOp != null : !((Object)((Object)this$stringReduceOp)).equals((Object)other$stringReduceOp)) {
            return false;
        }
        Map<String, ColumnReduction> this$customReductions = this.getCustomReductions();
        Map<String, ColumnReduction> other$customReductions = other.getCustomReductions();
        return !(this$customReductions == null ? other$customReductions != null : !((Object)this$customReductions).equals(other$customReductions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringReducer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $inputColumns = this.getInputColumns();
        result = result * 59 + ($inputColumns == null ? 43 : ((Object)$inputColumns).hashCode());
        Set<String> $inputColumnsSet = this.getInputColumnsSet();
        result = result * 59 + ($inputColumnsSet == null ? 43 : ((Object)$inputColumnsSet).hashCode());
        String $outputColumnName = this.getOutputColumnName();
        result = result * 59 + ($outputColumnName == null ? 43 : $outputColumnName.hashCode());
        StringReduceOp $stringReduceOp = this.getStringReduceOp();
        result = result * 59 + ($stringReduceOp == null ? 43 : ((Object)((Object)$stringReduceOp)).hashCode());
        Map<String, ColumnReduction> $customReductions = this.getCustomReductions();
        result = result * 59 + ($customReductions == null ? 43 : ((Object)$customReductions).hashCode());
        return result;
    }

    public static class Builder {
        private StringReduceOp defaultOp;
        private Map<String, StringReduceOp> opMap = new HashMap<String, StringReduceOp>();
        private Map<String, ColumnReduction> customReductions = new HashMap<String, ColumnReduction>();
        private Set<String> ignoreInvalidInColumns = new HashSet<String>();
        private String outputColumnName;
        private List<String> inputColumns;

        public Builder inputColumns(List<String> inputColumns) {
            this.inputColumns = inputColumns;
            return this;
        }

        public Builder(StringReduceOp defaultOp) {
            this.defaultOp = defaultOp;
        }

        public Builder outputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
            return this;
        }

        private Builder add(StringReduceOp op, String[] cols) {
            for (String s : cols) {
                this.opMap.put(s, op);
            }
            return this;
        }

        public Builder appendColumns(String ... columns) {
            return this.add(StringReduceOp.APPEND, columns);
        }

        public Builder prependColumns(String ... columns) {
            return this.add(StringReduceOp.PREPEND, columns);
        }

        public Builder mergeColumns(String ... columns) {
            return this.add(StringReduceOp.MERGE, columns);
        }

        public Builder replaceColumn(String ... columns) {
            return this.add(StringReduceOp.REPLACE, columns);
        }

        public Builder customReduction(String column, ColumnReduction columnReduction) {
            this.customReductions.put(column, columnReduction);
            return this;
        }

        public Builder setIgnoreInvalid(String ... columns) {
            Collections.addAll(this.ignoreInvalidInColumns, columns);
            return this;
        }

        public StringReducer build() {
            return new StringReducer(this);
        }
    }
}

