/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class InvalidValueColumnCondition
extends BaseColumnCondition {
    public InvalidValueColumnCondition(String columnName) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return !this.schema.getMetaData(this.columnIdx).isValid(writable);
    }

    @Override
    public String toString() {
        return "InvalidValueColumnCondition(columnName=\"" + this.columnName + "\")";
    }

    @Override
    public boolean condition(Object input) {
        if (input instanceof String) {
            return !this.schema.getMetaData(this.columnIdx).isValid(new Text(input.toString()));
        }
        if (input instanceof Double) {
            Double d = (Double)input;
            return !this.schema.getMetaData(this.columnIdx).isValid(new DoubleWritable(d));
        }
        if (input instanceof Integer) {
            Integer i = (Integer)input;
            return !this.schema.getMetaData(this.columnIdx).isValid(new IntWritable(i));
        }
        if (input instanceof Long) {
            Long l = (Long)input;
            return !this.schema.getMetaData(this.columnIdx).isValid(new LongWritable(l));
        }
        if (input instanceof Boolean) {
            Boolean b = (Boolean)input;
            return !this.schema.getMetaData(this.columnIdx).isValid(new BooleanWritable(b));
        }
        throw new IllegalStateException("Illegal type " + input.getClass().toString());
    }
}

