/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.timeseries.util;

import java.util.Iterator;
import java.util.List;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class TimeSeriesWritableUtils {
    public static RecordDetails getDetails(List<List<List<Writable>>> record) {
        int maxTimeSeriesLength = 0;
        for (List<List<Writable>> step : record) {
            maxTimeSeriesLength = Math.max(maxTimeSeriesLength, step.size());
        }
        return RecordDetails.builder().minValues(record.size()).maxTSLength(maxTimeSeriesLength).build();
    }

    public static Pair<INDArray, INDArray> convertWritablesSequence(List<List<List<Writable>>> timeSeriesRecord) {
        return TimeSeriesWritableUtils.convertWritablesSequence(timeSeriesRecord, TimeSeriesWritableUtils.getDetails(timeSeriesRecord));
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<INDArray, INDArray> convertWritablesSequence(List<List<List<Writable>>> list, RecordDetails details) {
        void var6_10;
        void var7_14;
        if (list.get(0).size() == 0) {
            throw new ZeroLengthSequenceException("Zero length sequence encountered");
        }
        List<Writable> firstStep = list.get(0).get(0);
        int size = 0;
        for (Writable writable : firstStep) {
            if (writable instanceof NDArrayWritable) {
                size += ((NDArrayWritable)writable).get().size(1);
                continue;
            }
            ++size;
        }
        INDArray arr = Nd4j.create((int[])new int[]{details.getMinValues(), size, details.getMaxTSLength()}, (char)'f');
        boolean needMaskArray = false;
        for (List<List<Writable>> list2 : list) {
            if (list2.size() >= details.getMaxTSLength()) continue;
            needMaskArray = true;
            break;
        }
        if (needMaskArray) {
            INDArray iNDArray = Nd4j.ones((int)details.getMinValues(), (int)details.getMaxTSLength());
        } else {
            Object var6_9 = null;
        }
        boolean bl = false;
        while (var7_14 < details.getMinValues()) {
            List<List<Writable>> sequence = list.get((int)var7_14);
            int t = 0;
            for (List<Writable> timeStep : sequence) {
                int k = t++;
                Iterator<Writable> iter = timeStep.iterator();
                int j = 0;
                while (iter.hasNext()) {
                    Writable w = iter.next();
                    if (w instanceof NDArrayWritable) {
                        INDArray row = ((NDArrayWritable)w).get();
                        arr.put(new INDArrayIndex[]{NDArrayIndex.point((int)var7_14), NDArrayIndex.interval((int)j, (int)(j + row.length())), NDArrayIndex.point((int)k)}, row);
                        j += row.length();
                        continue;
                    }
                    arr.putScalar((int)var7_14, j, k, w.toDouble());
                    ++j;
                }
            }
            if (needMaskArray) {
                int lastStep;
                for (int t2 = lastStep = sequence.size(); t2 < details.getMaxTSLength(); ++t2) {
                    var6_10.putScalar((int)var7_14, t2, 0.0);
                }
            }
            ++var7_14;
        }
        return new Pair((Object)arr, (Object)var6_10);
    }

    public static class RecordDetails {
        private int minValues;
        private int maxTSLength;

        public static RecordDetailsBuilder builder() {
            return new RecordDetailsBuilder();
        }

        public RecordDetails(int minValues, int maxTSLength) {
            this.minValues = minValues;
            this.maxTSLength = maxTSLength;
        }

        public int getMinValues() {
            return this.minValues;
        }

        public int getMaxTSLength() {
            return this.maxTSLength;
        }

        public static class RecordDetailsBuilder {
            private int minValues;
            private int maxTSLength;

            RecordDetailsBuilder() {
            }

            public RecordDetailsBuilder minValues(int minValues) {
                this.minValues = minValues;
                return this;
            }

            public RecordDetailsBuilder maxTSLength(int maxTSLength) {
                this.maxTSLength = maxTSLength;
                return this;
            }

            public RecordDetails build() {
                return new RecordDetails(this.minValues, this.maxTSLength);
            }

            public String toString() {
                return "TimeSeriesWritableUtils.RecordDetails.RecordDetailsBuilder(minValues=" + this.minValues + ", maxTSLength=" + this.maxTSLength + ")";
            }
        }
    }

    public static class ZeroLengthSequenceException
    extends RuntimeException {
        public ZeroLengthSequenceException() {
            this("");
        }

        public ZeroLengthSequenceException(String type) {
            super(String.format("Encountered zero-length %ssequence", type.equals("") ? "" : type + " "));
        }
    }
}

