/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CSVRegexRecordReader
extends CSVRecordReader {
    protected String[] regexs = null;
    protected Pattern[] patterns = null;
    protected String delimiter;
    protected String quote;

    public CSVRegexRecordReader(int skipNumLines, String delimiter, String quote, String[] regexs) {
        super(skipNumLines);
        this.delimiter = delimiter;
        this.quote = quote;
        this.regexs = regexs;
        if (regexs != null) {
            this.patterns = new Pattern[regexs.length];
            for (int i = 0; i < regexs.length; ++i) {
                if (regexs[i] == null) continue;
                this.patterns[i] = Pattern.compile(regexs[i]);
            }
        }
    }

    @Override
    protected List<Writable> parseLine(String line) {
        String[] split = line.split(this.delimiter, -1);
        ArrayList<Writable> ret = new ArrayList<Writable>();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (this.quote != null && s.startsWith(this.quote) && s.endsWith(this.quote)) {
                int n = this.quote.length();
                s = s.substring(n, s.length() - n).replace(this.quote + this.quote, this.quote);
            }
            if (this.regexs != null && this.regexs[i] != null) {
                Matcher m = this.patterns[i].matcher(s);
                if (m.matches()) {
                    for (int j = 1; j <= m.groupCount(); ++j) {
                        ret.add(new Text(m.group(j)));
                    }
                    continue;
                }
                throw new IllegalStateException("Invalid line: value does not match regex (regex=\"" + this.regexs[i] + "\"; value=\"" + s + "\"");
            }
            ret.add(new Text(s));
        }
        return ret;
    }
}

