/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence;

import java.util.Arrays;
import java.util.Collection;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class ConvertToSequence {
    private boolean singleStepSequencesMode;
    private final String[] keyColumns;
    private final SequenceComparator comparator;
    private Schema inputSchema;

    public ConvertToSequence(String keyColumn, SequenceComparator comparator) {
        this(false, new String[]{keyColumn}, comparator);
    }

    public ConvertToSequence(Collection<String> keyColumns, SequenceComparator comparator) {
        this(false, keyColumns.toArray(new String[keyColumns.size()]), comparator);
    }

    public ConvertToSequence(@JsonProperty(value="singleStepSequencesMode") boolean singleStepSequencesMode, @JsonProperty(value="keyColumn") String[] keyColumns, @JsonProperty(value="comparator") SequenceComparator comparator) {
        this.singleStepSequencesMode = singleStepSequencesMode;
        this.keyColumns = keyColumns;
        this.comparator = comparator;
    }

    public SequenceSchema transform(Schema schema) {
        return new SequenceSchema(schema.getColumnMetaData());
    }

    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
        if (!this.singleStepSequencesMode) {
            this.comparator.setSchema(this.transform(schema));
        }
    }

    public String toString() {
        if (this.singleStepSequencesMode) {
            return "ConvertToSequence()";
        }
        if (this.keyColumns.length == 1) {
            return "ConvertToSequence(keyColumn=\"" + this.keyColumns[0] + "\",comparator=" + this.comparator + ")";
        }
        return "ConvertToSequence(keyColumns=\"" + Arrays.toString(this.keyColumns) + "\",comparator=" + this.comparator + ")";
    }

    public boolean isSingleStepSequencesMode() {
        return this.singleStepSequencesMode;
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public SequenceComparator getComparator() {
        return this.comparator;
    }

    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public void setSingleStepSequencesMode(boolean singleStepSequencesMode) {
        this.singleStepSequencesMode = singleStepSequencesMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToSequence)) {
            return false;
        }
        ConvertToSequence other = (ConvertToSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSingleStepSequencesMode() != other.isSingleStepSequencesMode()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getKeyColumns(), other.getKeyColumns())) {
            return false;
        }
        SequenceComparator this$comparator = this.getComparator();
        SequenceComparator other$comparator = other.getComparator();
        return !(this$comparator == null ? other$comparator != null : !this$comparator.equals(other$comparator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvertToSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingleStepSequencesMode() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getKeyColumns());
        SequenceComparator $comparator = this.getComparator();
        result = result * 59 + ($comparator == null ? 43 : $comparator.hashCode());
        return result;
    }
}

