/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ui;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.DataAnalysis;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.analysis.columns.DoubleAnalysis;
import org.datavec.api.transform.analysis.columns.IntegerAnalysis;
import org.datavec.api.transform.analysis.columns.LongAnalysis;
import org.datavec.api.transform.analysis.columns.NDArrayAnalysis;
import org.datavec.api.transform.analysis.columns.StringAnalysis;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.ui.DivObject;
import org.datavec.api.transform.ui.components.RenderableComponentHistogram;
import org.datavec.api.transform.ui.components.RenderableComponentTable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class HtmlAnalysis {
    private HtmlAnalysis() {
    }

    public static String createHtmlAnalysisString(DataAnalysis analysis) throws Exception {
        Configuration cfg = new Configuration(new Version(2, 3, 23));
        cfg.setClassForTemplateLoading(HtmlAnalysis.class, "/templates/");
        cfg.setIncompatibleImprovements(new Version(2, 3, 23));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setLocale(Locale.US);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        HashMap<String, Object> input = new HashMap<String, Object>();
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        List<ColumnAnalysis> caList = analysis.getColumnAnalysis();
        Schema schema = analysis.getSchema();
        int n = caList.size();
        String[][] table = new String[n][3];
        ArrayList<DivObject> divs = new ArrayList<DivObject>();
        ArrayList<String> histogramDivNames = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            long[] counts;
            double[] buckets;
            ColumnAnalysis ca = caList.get(i);
            String name = schema.getName(i);
            ColumnType type = schema.getType(i);
            table[i][0] = name;
            table[i][1] = type.toString();
            table[i][2] = ca.toString().replaceAll(",", ", ");
            switch (type) {
                case String: {
                    StringAnalysis sa = (StringAnalysis)ca;
                    buckets = sa.getHistogramBuckets();
                    counts = sa.getHistogramBucketCounts();
                    break;
                }
                case Integer: {
                    IntegerAnalysis ia = (IntegerAnalysis)ca;
                    buckets = ia.getHistogramBuckets();
                    counts = ia.getHistogramBucketCounts();
                    break;
                }
                case Long: {
                    LongAnalysis la = (LongAnalysis)ca;
                    buckets = la.getHistogramBuckets();
                    counts = la.getHistogramBucketCounts();
                    break;
                }
                case Double: {
                    DoubleAnalysis da = (DoubleAnalysis)ca;
                    buckets = da.getHistogramBuckets();
                    counts = da.getHistogramBucketCounts();
                    break;
                }
                case NDArray: {
                    NDArrayAnalysis na = (NDArrayAnalysis)ca;
                    buckets = na.getHistogramBuckets();
                    counts = na.getHistogramBucketCounts();
                    break;
                }
                case Categorical: 
                case Time: 
                case Bytes: {
                    buckets = null;
                    counts = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid/unknown column type: " + (Object)((Object)type));
                }
            }
            if (buckets == null) continue;
            RenderableComponentHistogram.Builder histBuilder = new RenderableComponentHistogram.Builder();
            for (int j = 0; j < counts.length; ++j) {
                histBuilder.addBin(buckets[j], buckets[j + 1], counts[j]);
            }
            histBuilder.margins(60, 60, 90, 20);
            RenderableComponentHistogram hist = histBuilder.title(name).build();
            String divName = "histdiv_" + name.replaceAll("\\W", "");
            divs.add(new DivObject(divName, ret.writeValueAsString((Object)hist)));
            histogramDivNames.add(divName);
        }
        RenderableComponentTable rct = new RenderableComponentTable.Builder().table(table).header("Column Name", "Column Type", "Column Analysis").backgroundColor("#FFFFFF").headerColor("#CCCCCC").colWidthsPercent(20.0, 10.0, 70.0).border(1).padLeftPx(4).padRightPx(4).build();
        divs.add(new DivObject("tablesource", ret.writeValueAsString((Object)rct)));
        input.put("divs", divs);
        input.put("histogramIDs", histogramDivNames);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss zzz").withZone(DateTimeZone.UTC);
        long currTime = System.currentTimeMillis();
        String dateTime = formatter.print(currTime);
        input.put("datetime", dateTime);
        Template template = cfg.getTemplate("analysis.ftl");
        StringWriter stringWriter = new StringWriter();
        template.process(input, (Writer)stringWriter);
        return ((Object)stringWriter).toString();
    }

    public static void createHtmlAnalysisFile(DataAnalysis dataAnalysis, File output) throws Exception {
        String str = HtmlAnalysis.createHtmlAnalysisString(dataAnalysis);
        FileUtils.writeStringToFile((File)output, (String)str);
    }
}

