/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.condition;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"columnToReplaceIdx"})
public class ConditionalReplaceValueTransform
implements Transform,
ColumnOp {
    private final String columnToReplace;
    private final Writable newValue;
    private final Condition condition;
    private int columnToReplaceIdx = -1;

    public ConditionalReplaceValueTransform(@JsonProperty(value="columnToReplace") String columnToReplace, @JsonProperty(value="newValue") Writable newValue, @JsonProperty(value="condition") Condition condition) {
        this.columnToReplace = columnToReplace;
        this.newValue = newValue;
        this.condition = condition;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.columnToReplaceIdx = inputSchema.getColumnNames().indexOf(this.columnToReplace);
        if (this.columnToReplaceIdx < 0) {
            throw new IllegalStateException("Column \"" + this.columnToReplace + "\" not found in input schema");
        }
        this.condition.setInputSchema(inputSchema);
    }

    @Override
    public Schema getInputSchema() {
        return this.condition.getInputSchema();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (this.condition.condition(writables)) {
            ArrayList<Writable> newList = new ArrayList<Writable>(writables);
            newList.set(this.columnToReplaceIdx, this.newValue);
            return newList;
        }
        return writables;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        if (this.condition.condition(input)) {
            return this.newValue;
        }
        return input;
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Object> out = new ArrayList<Object>();
        for (Object step : seq) {
            out.add(this.map(step));
        }
        return out;
    }

    public String toString() {
        return "ConditionalReplaceValueTransform(replaceColumn=\"" + this.columnToReplace + "\",newValue=" + this.newValue + ",condition=" + this.condition + ")";
    }

    @Override
    public String outputColumnName() {
        return this.columnToReplace;
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnNames();
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnToReplace};
    }

    @Override
    public String columnName() {
        return this.columnToReplace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionalReplaceValueTransform)) {
            return false;
        }
        ConditionalReplaceValueTransform other = (ConditionalReplaceValueTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnToReplace = this.columnToReplace;
        String other$columnToReplace = other.columnToReplace;
        if (this$columnToReplace == null ? other$columnToReplace != null : !this$columnToReplace.equals(other$columnToReplace)) {
            return false;
        }
        Writable this$newValue = this.newValue;
        Writable other$newValue = other.newValue;
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        Condition this$condition = this.condition;
        Condition other$condition = other.condition;
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionalReplaceValueTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnToReplace = this.columnToReplace;
        result = result * 59 + ($columnToReplace == null ? 43 : $columnToReplace.hashCode());
        Writable $newValue = this.newValue;
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        Condition $condition = this.condition;
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }
}

