/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.NonNull;
import org.datavec.api.split.BaseInputSplit;

public class TransformSplit
extends BaseInputSplit {
    private final BaseInputSplit sourceSplit;
    private final URITransform transform;

    public TransformSplit(@NonNull BaseInputSplit sourceSplit, @NonNull URITransform transform) throws URISyntaxException {
        if (sourceSplit == null) {
            throw new NullPointerException("sourceSplit");
        }
        if (transform == null) {
            throw new NullPointerException("transform");
        }
        this.sourceSplit = sourceSplit;
        this.transform = transform;
        this.initialize();
    }

    public static TransformSplit ofSearchReplace(@NonNull BaseInputSplit sourceSplit, final @NonNull String search, final @NonNull String replace) throws URISyntaxException {
        if (sourceSplit == null) {
            throw new NullPointerException("sourceSplit");
        }
        if (search == null) {
            throw new NullPointerException("search");
        }
        if (replace == null) {
            throw new NullPointerException("replace");
        }
        return new TransformSplit(sourceSplit, new URITransform(){

            @Override
            public URI apply(URI uri) throws URISyntaxException {
                return new URI(uri.toString().replace(search, replace));
            }
        });
    }

    private void initialize() throws URISyntaxException {
        this.length = this.sourceSplit.length();
        this.locations = new URI[this.sourceSplit.locations().length];
        URI[] sourceLocations = this.sourceSplit.locations();
        for (int i = 0; i < sourceLocations.length; ++i) {
            this.locations[i] = this.transform.apply(sourceLocations[i]);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    public static interface URITransform {
        public URI apply(URI var1) throws URISyntaxException;
    }
}

