/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.filter;

import java.beans.ConstructorProperties;
import java.util.List;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class InvalidNumColumns
implements Filter {
    private Schema inputSchema;

    @Override
    public boolean removeExample(Object writables) {
        return false;
    }

    @Override
    public boolean removeSequence(Object sequence) {
        return false;
    }

    @Override
    public boolean removeExample(List<Writable> writables) {
        return writables.size() != this.inputSchema.numColumns();
    }

    @Override
    public boolean removeSequence(List<List<Writable>> sequence) {
        for (List<Writable> record : sequence) {
            if (record.size() == this.inputSchema.numColumns()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public String outputColumnName() {
        return this.inputSchema.getColumnNames().get(0);
    }

    @Override
    public String[] outputColumnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvalidNumColumns)) {
            return false;
        }
        InvalidNumColumns other = (InvalidNumColumns)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        return !(this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvalidNumColumns;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        return result;
    }

    public String toString() {
        return "InvalidNumColumns(inputSchema=" + this.getInputSchema() + ")";
    }

    @ConstructorProperties(value={"inputSchema"})
    public InvalidNumColumns(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }
}

