/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils {
    private static Logger log = LoggerFactory.getLogger(ArchiveUtils.class);

    public static void unzipFileTo(String file, String dest) throws IOException {
        File target = new File(file);
        if (!target.exists()) {
            throw new IllegalArgumentException("Archive doesnt exist");
        }
        FileInputStream fin = new FileInputStream(target);
        int BUFFER = 2048;
        byte[] data = new byte[BUFFER];
        if (file.endsWith(".zip") || file.endsWith(".jar")) {
            ZipInputStream zis = new ZipInputStream(fin);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(dest + File.separator + fileName);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    zis.closeEntry();
                    ze = zis.getNextEntry();
                    continue;
                }
                log.info("file unzip : " + newFile.getAbsoluteFile());
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(data)) > 0) {
                    fos.write(data, 0, len);
                }
                fos.flush();
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.close();
        } else if (file.endsWith(".tar")) {
            BufferedInputStream in = new BufferedInputStream(fin);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)in);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                int count;
                log.info("Extracting: " + entry.getName());
                if (entry.isDirectory()) {
                    File f = new File(dest + File.separator + entry.getName());
                    f.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(dest + File.separator + entry.getName());
                BufferedOutputStream destStream = new BufferedOutputStream(fos, BUFFER);
                while ((count = tarIn.read(data, 0, BUFFER)) != -1) {
                    destStream.write(data, 0, count);
                }
                destStream.flush();
                IOUtils.closeQuietly((OutputStream)destStream);
            }
            tarIn.close();
        } else if (file.endsWith(".tar.gz") || file.endsWith(".tgz")) {
            BufferedInputStream in = new BufferedInputStream(fin);
            GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                int count;
                log.info("Extracting: " + entry.getName());
                if (entry.isDirectory()) {
                    File f = new File(dest + File.separator + entry.getName());
                    f.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(dest + File.separator + entry.getName());
                BufferedOutputStream destStream = new BufferedOutputStream(fos, BUFFER);
                while ((count = tarIn.read(data, 0, BUFFER)) != -1) {
                    destStream.write(data, 0, count);
                }
                destStream.flush();
                IOUtils.closeQuietly((OutputStream)destStream);
            }
            tarIn.close();
        } else if (file.endsWith(".gz")) {
            GZIPInputStream is2 = new GZIPInputStream(fin);
            File extracted = new File(target.getParent(), target.getName().replace(".gz", ""));
            if (extracted.exists()) {
                extracted.delete();
            }
            extracted.createNewFile();
            FileOutputStream fos = FileUtils.openOutputStream((File)extracted);
            IOUtils.copyLarge((InputStream)is2, (OutputStream)fos);
            is2.close();
            fos.flush();
            ((OutputStream)fos).close();
        }
    }
}

