/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"ratio", "inputSchema", "columnNumber"})
public class MinMaxNormalizer
extends BaseDoubleTransform {
    protected final double min;
    protected final double max;
    protected final double newMin;
    protected final double newMax;
    protected final double ratio;

    public MinMaxNormalizer(String columnName, double min, double max) {
        this(columnName, min, max, 0.0, 1.0);
    }

    public MinMaxNormalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="newMin") double newMin, @JsonProperty(value="newMax") double newMax) {
        super(columnName);
        this.min = min;
        this.max = max;
        this.newMin = newMin;
        this.newMax = newMax;
        this.ratio = (newMax - newMin) / (max - min);
    }

    @Override
    public Writable map(Writable writable) {
        double val = writable.toDouble();
        if (Double.isNaN(val)) {
            return new DoubleWritable(0.0);
        }
        return new DoubleWritable(this.ratio * (val - this.min) + this.newMin);
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnMeta) {
        return new DoubleMetaData(newColumnName, this.newMin, this.newMax);
    }

    @Override
    public String toString() {
        return "MinMaxNormalizer(min=" + this.min + ",max=" + this.max + ",newMin=" + this.newMin + ",newMax=" + this.newMax + ")";
    }
}

