/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.NumericalColumnAnalysis;

public class IntegerAnalysis
extends NumericalColumnAnalysis {
    private final int min;
    private final int max;

    private IntegerAnalysis(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
    }

    @Override
    public String toString() {
        return "IntegerAnalysis(min=" + this.min + ",max=" + this.max + "," + super.toString() + ")";
    }

    @Override
    public double getMinDouble() {
        return this.min;
    }

    @Override
    public double getMaxDouble() {
        return this.max;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Integer;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerAnalysis)) {
            return false;
        }
        IntegerAnalysis other = (IntegerAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMin() != other.getMin()) {
            return false;
        }
        return this.getMax() == other.getMax();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntegerAnalysis;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getMin();
        result = result * 59 + this.getMax();
        return result;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static class Builder
    extends NumericalColumnAnalysis.Builder<Builder> {
        private int min;
        private int max;

        public Builder min(int min) {
            this.min = min;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }

        public IntegerAnalysis build() {
            return new IntegerAnalysis(this);
        }
    }
}

