/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.berkeley;

import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public abstract class MapFactory<K, V>
implements Serializable {
    public abstract Map<K, V> buildMap();

    public static class WeakHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new WeakHashMap();
        }
    }

    public static class TreeMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new TreeMap();
        }
    }

    public static class IdentityHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new IdentityHashMap();
        }
    }

    public static class HashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new HashMap();
        }
    }
}

