/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class StringToTimeTransform
extends BaseColumnTransform {
    private final String timeFormat;
    private final DateTimeZone timeZone;
    private final Long minValidTime;
    private final Long maxValidTime;
    private transient DateTimeFormatter formatter;

    public StringToTimeTransform(String columnName, String timeFormat, TimeZone timeZone) {
        this(columnName, timeFormat, timeZone, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, DateTimeZone timeZone) {
        this(columnName, timeFormat, timeZone, null, null);
    }

    public StringToTimeTransform(String columnName, String timeFormat, TimeZone timeZone, Long minValidTime, Long maxValidTime) {
        this(columnName, timeFormat, DateTimeZone.forTimeZone((TimeZone)timeZone), minValidTime, maxValidTime);
    }

    public StringToTimeTransform(String columnName, String timeFormat, DateTimeZone timeZone, Long minValidTime, Long maxValidTime) {
        super(columnName);
        this.timeFormat = timeFormat;
        this.timeZone = timeZone;
        this.minValidTime = minValidTime;
        this.maxValidTime = maxValidTime;
        this.formatter = DateTimeFormat.forPattern((String)timeFormat).withZone(timeZone);
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(ColumnMetaData oldColumnType) {
        return new TimeMetaData(this.timeZone, this.minValidTime, this.maxValidTime);
    }

    @Override
    public Writable map(Writable columnWritable) {
        String str = columnWritable.toString();
        long time = this.formatter.parseMillis(str);
        return new LongWritable(time);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringToTimeTransform(timeZone=").append(this.timeZone);
        if (this.minValidTime != null) {
            sb.append(",minValidTime=").append(this.minValidTime);
        }
        if (this.maxValidTime != null) {
            if (this.minValidTime != null) {
                sb.append(",");
            }
            sb.append("maxValidTime=").append(this.maxValidTime);
        }
        sb.append(")");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(this.timeZone);
    }
}

