/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class StandardizeNormalizer
extends BaseDoubleTransform {
    protected final double mean;
    protected final double sigma;

    public StandardizeNormalizer(String columnName, double mean, double sigma) {
        super(columnName);
        this.mean = mean;
        this.sigma = sigma;
    }

    @Override
    public Writable map(Writable writable) {
        double val = writable.toDouble();
        return new DoubleWritable((val - this.mean) / this.sigma);
    }

    @Override
    public String toString() {
        return "StandardizeNormalizer(mean=" + this.mean + ",sigma=" + this.sigma + ")";
    }
}

