/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class DoubleMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final double scalar;

    public DoubleMathOpTransform(String columnName, MathOp mathOp, double scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof DoubleMetaData)) {
            throw new IllegalStateException("Column is not an integer column");
        }
        DoubleMetaData meta = (DoubleMetaData)oldColumnType;
        Double minValue = meta.getMin();
        Double maxValue = meta.getMax();
        if (minValue != null) {
            minValue = this.doOp(minValue);
        }
        if (maxValue != null) {
            maxValue = this.doOp(maxValue);
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            Double temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new DoubleMetaData(minValue, maxValue);
    }

    private double doOp(double input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new DoubleWritable(this.doOp(columnWritable.toDouble()));
    }

    @Override
    public String toString() {
        return "DoubleMathOpTransform(mathOp=" + (Object)((Object)this.mathOp) + ",scalar=" + this.scalar + ")";
    }
}

