/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class DoubleColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public DoubleColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData() {
        return new DoubleMetaData();
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                double sum = 0.0;
                for (Writable w : input) {
                    sum += w.toDouble();
                }
                return new DoubleWritable(sum);
            }
            case Subtract: {
                return new DoubleWritable(input[0].toDouble() - input[1].toDouble());
            }
            case Multiply: {
                double product = 1.0;
                for (Writable w : input) {
                    product *= w.toDouble();
                }
                return new DoubleWritable(product);
            }
            case Divide: {
                return new DoubleWritable(input[0].toDouble() / input[1].toDouble());
            }
            case Modulus: {
                return new DoubleWritable(input[0].toDouble() % input[1].toDouble());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }
}

