/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;

public abstract class BaseColumnTransform
extends BaseTransform {
    protected final String columnName;
    protected int columnNumber = -1;
    private static final long serialVersionUID = 0L;

    public BaseColumnTransform(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.columnNumber = inputSchema.getIndexOfColumn(this.columnName);
    }

    @Override
    public Schema transform(Schema schema) {
        if (this.columnNumber == -1) {
            throw new IllegalStateException("columnNumber == -1 -> setInputSchema not called?");
        }
        List<ColumnMetaData> oldMeta = schema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size());
        Iterator<ColumnMetaData> typesIter = oldMeta.iterator();
        int i = 0;
        while (typesIter.hasNext()) {
            ColumnMetaData t = typesIter.next();
            if (i++ == this.columnNumber) {
                newMeta.add(this.getNewColumnMetaData(t));
                continue;
            }
            newMeta.add(t);
        }
        return schema.newSchema(new ArrayList<String>(schema.getColumnNames()), newMeta);
    }

    public abstract ColumnMetaData getNewColumnMetaData(ColumnMetaData var1);

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int n = writables.size();
        ArrayList<Writable> out = new ArrayList<Writable>(n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == this.columnNumber) {
                Writable newW = this.map(w);
                out.add(newW);
                continue;
            }
            out.add(w);
        }
        return out;
    }

    public abstract Writable map(Writable var1);

    @Override
    public abstract String toString();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseColumnTransform)) {
            return false;
        }
        BaseColumnTransform other = (BaseColumnTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        return this.getColumnNumber() == other.getColumnNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseColumnTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        result = result * 59 + this.getColumnNumber();
        return result;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }
}

