/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.rank;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.writable.Writable;

public class CalculateSortedRank
implements Serializable {
    private final String newColumnName;
    private final String sortOnColumn;
    private final Comparator<Writable> comparator;
    private final boolean ascending;
    private Schema inputSchema;

    public CalculateSortedRank(String newColumnName, String sortOnColumn, Comparator<Writable> comparator) {
        this(newColumnName, sortOnColumn, comparator, true);
    }

    public CalculateSortedRank(String newColumnName, String sortOnColumn, Comparator<Writable> comparator, boolean ascending) {
        this.newColumnName = newColumnName;
        this.sortOnColumn = sortOnColumn;
        this.comparator = comparator;
        this.ascending = ascending;
    }

    public Schema transform(Schema inputSchema) {
        if (inputSchema instanceof SequenceSchema) {
            throw new IllegalStateException("Calculating sorted rank on sequences: not yet supported");
        }
        List<String> origNames = inputSchema.getColumnNames();
        List<ColumnMetaData> origMeta = inputSchema.getColumnMetaData();
        ArrayList<String> newNames = new ArrayList<String>(origNames);
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(origMeta);
        newNames.add(this.newColumnName);
        newMeta.add(new LongMetaData(0L, null));
        return inputSchema.newSchema(newNames, newMeta);
    }

    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
    }

    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public String toString() {
        return "CalculateSortedRank(newColumnName=\"" + this.newColumnName + "\", comparator=" + this.comparator + ")";
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public String getSortOnColumn() {
        return this.sortOnColumn;
    }

    public Comparator<Writable> getComparator() {
        return this.comparator;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateSortedRank)) {
            return false;
        }
        CalculateSortedRank other = (CalculateSortedRank)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        String this$sortOnColumn = this.getSortOnColumn();
        String other$sortOnColumn = other.getSortOnColumn();
        if (this$sortOnColumn == null ? other$sortOnColumn != null : !this$sortOnColumn.equals(other$sortOnColumn)) {
            return false;
        }
        Comparator<Writable> this$comparator = this.getComparator();
        Comparator<Writable> other$comparator = other.getComparator();
        if (this$comparator == null ? other$comparator != null : !((Object)this$comparator).equals(other$comparator)) {
            return false;
        }
        if (this.isAscending() != other.isAscending()) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        return !(this$inputSchema == null ? other$inputSchema != null : !this$inputSchema.equals(other$inputSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateSortedRank;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        String $sortOnColumn = this.getSortOnColumn();
        result = result * 59 + ($sortOnColumn == null ? 43 : $sortOnColumn.hashCode());
        Comparator<Writable> $comparator = this.getComparator();
        result = result * 59 + ($comparator == null ? 43 : $comparator.hashCode());
        result = result * 59 + (this.isAscending() ? 79 : 97);
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : $inputSchema.hashCode());
        return result;
    }
}

