/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.writable.Writable;

public class DoubleMetaData
implements ColumnMetaData {
    private final Double min;
    private final Double max;
    private final boolean allowNaN;
    private final boolean allowInfinite;

    public DoubleMetaData() {
        this(null, null, false, false);
    }

    public DoubleMetaData(Double min, Double max) {
        this(min, max, false, false);
    }

    public DoubleMetaData(Double min, Double max, boolean allowNaN, boolean allowInfinite) {
        this.min = min;
        this.max = max;
        this.allowNaN = allowNaN;
        this.allowInfinite = allowInfinite;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Double;
    }

    @Override
    public boolean isValid(Writable writable) {
        double d;
        try {
            d = writable.toDouble();
        }
        catch (Exception e) {
            return false;
        }
        if (this.allowNaN && Double.isNaN(d)) {
            return true;
        }
        if (this.allowInfinite && Double.isInfinite(d)) {
            return true;
        }
        if (this.min != null && d < this.min) {
            return false;
        }
        return this.max == null || !(d > this.max);
    }

    @Override
    public DoubleMetaData clone() {
        return new DoubleMetaData(this.min, this.max, this.allowNaN, this.allowInfinite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoubleMetaData(");
        boolean needComma = false;
        if (this.min != null) {
            sb.append("minAllowed=").append(this.min);
            needComma = true;
        }
        if (this.max != null) {
            if (needComma) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.max);
            needComma = true;
        }
        if (needComma) {
            sb.append(",");
        }
        sb.append("allowNaN=").append(this.allowNaN).append(",allowInfinite=").append(this.allowInfinite).append(")");
        return sb.toString();
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public boolean isAllowNaN() {
        return this.allowNaN;
    }

    public boolean isAllowInfinite() {
        return this.allowInfinite;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleMetaData)) {
            return false;
        }
        DoubleMetaData other = (DoubleMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$min = this.getMin();
        Double other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        Double this$max = this.getMax();
        Double other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        if (this.isAllowNaN() != other.isAllowNaN()) {
            return false;
        }
        return this.isAllowInfinite() == other.isAllowInfinite();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        Double $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        result = result * 59 + (this.isAllowNaN() ? 79 : 97);
        result = result * 59 + (this.isAllowInfinite() ? 79 : 97);
        return result;
    }
}

