/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class StringColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final String value;
    private final Set<String> set;

    public StringColumnCondition(String column, ConditionOp op, String value) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public StringColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, String value) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.Equal && op != ConditionOp.NotEqual) {
            throw new IllegalArgumentException("Invalid condition op: can only use this constructor with Equal or NotEqual conditions");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public StringColumnCondition(String column, ConditionOp op, Set<String> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public StringColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<String> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case Equal: {
                return this.value.equals(writable.toString());
            }
            case NotEqual: {
                return !this.value.equals(writable.toString());
            }
            case InSet: {
                return this.set.contains(writable.toString());
            }
            case NotInSet: {
                return !this.set.contains(writable.toString());
            }
            case LessThan: 
            case LessOrEqual: 
            case GreaterThan: 
            case GreaterOrEqual: {
                throw new UnsupportedOperationException("Cannot use ConditionOp \"" + (Object)((Object)this.op) + "\" on String column");
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "StringColumnCondition(colName=\"" + this.column + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }
}

