/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class IntegerColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final int value;
    private final Set<Integer> set;

    public IntegerColumnCondition(String column, ConditionOp op, int value) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public IntegerColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, int value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public IntegerColumnCondition(String column, ConditionOp op, Set<Integer> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public IntegerColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Integer> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = 0;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toInt() < this.value;
            }
            case LessOrEqual: {
                return writable.toInt() <= this.value;
            }
            case GreaterThan: {
                return writable.toInt() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toInt() >= this.value;
            }
            case Equal: {
                return writable.toInt() == this.value;
            }
            case NotEqual: {
                return writable.toInt() != this.value;
            }
            case InSet: {
                return this.set.contains(writable.toInt());
            }
            case NotInSet: {
                return !this.set.contains(writable.toInt());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "IntegerColumnCondition(colName=\"" + this.column + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : Integer.valueOf(this.value)) + ")";
    }
}

