/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform;

import java.io.Serializable;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.filter.Filter;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.reduce.IReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.ConvertFromSequence;
import org.datavec.api.transform.sequence.ConvertToSequence;
import org.datavec.api.transform.sequence.SequenceSplit;

public class DataAction
implements Serializable {
    private Transform transform;
    private Filter filter;
    private ConvertToSequence convertToSequence;
    private ConvertFromSequence convertFromSequence;
    private SequenceSplit sequenceSplit;
    private IReducer reducer;
    private CalculateSortedRank calculateSortedRank;

    public DataAction(Transform transform) {
        this.transform = transform;
    }

    public DataAction(Filter filter) {
        this.filter = filter;
    }

    public DataAction(ConvertToSequence convertToSequence) {
        this.convertToSequence = convertToSequence;
    }

    public DataAction(ConvertFromSequence convertFromSequence) {
        this.convertFromSequence = convertFromSequence;
    }

    public DataAction(SequenceSplit sequenceSplit) {
        this.sequenceSplit = sequenceSplit;
    }

    public DataAction(IReducer reducer) {
        this.reducer = reducer;
    }

    public DataAction(CalculateSortedRank calculateSortedRank) {
        this.calculateSortedRank = calculateSortedRank;
    }

    public String toString() {
        String str;
        if (this.transform != null) {
            str = this.transform.toString();
        } else if (this.filter != null) {
            str = this.filter.toString();
        } else if (this.convertToSequence != null) {
            str = this.convertToSequence.toString();
        } else if (this.convertFromSequence != null) {
            str = this.convertFromSequence.toString();
        } else if (this.sequenceSplit != null) {
            str = this.sequenceSplit.toString();
        } else if (this.reducer != null) {
            str = this.reducer.toString();
        } else if (this.calculateSortedRank != null) {
            str = this.calculateSortedRank.toString();
        } else {
            throw new IllegalStateException("Invalid DataAction: does not contain any operation to perform (all fields are null)");
        }
        return "DataAction(" + str + ")";
    }

    public Schema getSchema() {
        if (this.transform != null) {
            return this.transform.getInputSchema();
        }
        if (this.filter != null) {
            return this.filter.getInputSchema();
        }
        if (this.convertToSequence != null) {
            return this.convertToSequence.getInputSchema();
        }
        if (this.convertFromSequence != null) {
            return this.convertFromSequence.getInputSchema();
        }
        if (this.sequenceSplit != null) {
            return this.sequenceSplit.getInputSchema();
        }
        if (this.reducer != null) {
            return this.reducer.getInputSchema();
        }
        if (this.calculateSortedRank != null) {
            return this.calculateSortedRank.getInputSchema();
        }
        throw new IllegalStateException("Invalid DataAction: does not contain any operation to perform (all fields are null)");
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ConvertToSequence getConvertToSequence() {
        return this.convertToSequence;
    }

    public ConvertFromSequence getConvertFromSequence() {
        return this.convertFromSequence;
    }

    public SequenceSplit getSequenceSplit() {
        return this.sequenceSplit;
    }

    public IReducer getReducer() {
        return this.reducer;
    }

    public CalculateSortedRank getCalculateSortedRank() {
        return this.calculateSortedRank;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setConvertToSequence(ConvertToSequence convertToSequence) {
        this.convertToSequence = convertToSequence;
    }

    public void setConvertFromSequence(ConvertFromSequence convertFromSequence) {
        this.convertFromSequence = convertFromSequence;
    }

    public void setSequenceSplit(SequenceSplit sequenceSplit) {
        this.sequenceSplit = sequenceSplit;
    }

    public void setReducer(IReducer reducer) {
        this.reducer = reducer;
    }

    public void setCalculateSortedRank(CalculateSortedRank calculateSortedRank) {
        this.calculateSortedRank = calculateSortedRank;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataAction)) {
            return false;
        }
        DataAction other = (DataAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Transform this$transform = this.getTransform();
        Transform other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !this$transform.equals(other$transform)) {
            return false;
        }
        Filter this$filter = this.getFilter();
        Filter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        ConvertToSequence this$convertToSequence = this.getConvertToSequence();
        ConvertToSequence other$convertToSequence = other.getConvertToSequence();
        if (this$convertToSequence == null ? other$convertToSequence != null : !((Object)this$convertToSequence).equals(other$convertToSequence)) {
            return false;
        }
        ConvertFromSequence this$convertFromSequence = this.getConvertFromSequence();
        ConvertFromSequence other$convertFromSequence = other.getConvertFromSequence();
        if (this$convertFromSequence == null ? other$convertFromSequence != null : !((Object)this$convertFromSequence).equals(other$convertFromSequence)) {
            return false;
        }
        SequenceSplit this$sequenceSplit = this.getSequenceSplit();
        SequenceSplit other$sequenceSplit = other.getSequenceSplit();
        if (this$sequenceSplit == null ? other$sequenceSplit != null : !this$sequenceSplit.equals(other$sequenceSplit)) {
            return false;
        }
        IReducer this$reducer = this.getReducer();
        IReducer other$reducer = other.getReducer();
        if (this$reducer == null ? other$reducer != null : !this$reducer.equals(other$reducer)) {
            return false;
        }
        CalculateSortedRank this$calculateSortedRank = this.getCalculateSortedRank();
        CalculateSortedRank other$calculateSortedRank = other.getCalculateSortedRank();
        return !(this$calculateSortedRank == null ? other$calculateSortedRank != null : !((Object)this$calculateSortedRank).equals(other$calculateSortedRank));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Transform $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
        Filter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        ConvertToSequence $convertToSequence = this.getConvertToSequence();
        result = result * 59 + ($convertToSequence == null ? 43 : ((Object)$convertToSequence).hashCode());
        ConvertFromSequence $convertFromSequence = this.getConvertFromSequence();
        result = result * 59 + ($convertFromSequence == null ? 43 : ((Object)$convertFromSequence).hashCode());
        SequenceSplit $sequenceSplit = this.getSequenceSplit();
        result = result * 59 + ($sequenceSplit == null ? 43 : $sequenceSplit.hashCode());
        IReducer $reducer = this.getReducer();
        result = result * 59 + ($reducer == null ? 43 : $reducer.hashCode());
        CalculateSortedRank $calculateSortedRank = this.getCalculateSortedRank();
        result = result * 59 + ($calculateSortedRank == null ? 43 : ((Object)$calculateSortedRank).hashCode());
        return result;
    }
}

