/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.misc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class MatlabRecordReader
extends FileRecordReader {
    private List<Collection<Writable>> records = new ArrayList<Collection<Writable>>();
    private Iterator<Collection<Writable>> currIter;

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public Collection<Writable> next() {
        if (this.currIter != null && this.currIter.hasNext()) {
            return this.currIter.next();
        }
        this.records.clear();
        Collection<Writable> next = super.next();
        String val = next.iterator().next().toString();
        StringReader reader = new StringReader(val);
        ArrayList<DoubleWritable> currRecord = new ArrayList<DoubleWritable>();
        StringBuilder fileContent = new StringBuilder();
        boolean isComment = false;
        this.records.add(currRecord);
        try {
            int c;
            while ((c = reader.read()) != -1) {
                char chr = (char)c;
                if (chr == '%') {
                    isComment = true;
                }
                if (chr == '\n' || chr == '\r') {
                    isComment = false;
                    if (fileContent.length() > 0) {
                        currRecord.add(new DoubleWritable(new Double(fileContent.toString())));
                    }
                    if (currRecord.size() > 0) {
                        currRecord = new ArrayList();
                        this.records.add(currRecord);
                    }
                    fileContent = new StringBuilder();
                    continue;
                }
                if (isComment) continue;
                if (chr == '\t' || chr == ' ') {
                    if (fileContent.length() <= 0) continue;
                    currRecord.add(new DoubleWritable(new Double(fileContent.toString())));
                    fileContent = new StringBuilder();
                    continue;
                }
                fileContent.append(chr);
            }
            if (fileContent.length() > 0) {
                currRecord.add(new DoubleWritable(new Double(fileContent.toString())));
            }
            this.currIter = this.records.iterator();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Unable to determine structure as Matlab ASCII file: " + ex);
        }
        throw new IllegalStateException("Strange state detected");
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading Matlab data from DataInputStream: not yet implemented");
    }
}

